//+------------------------------------------------------------------+
//|                                           MML_Multi_Option_v1.23 |
//+------------------------------------------------------------------|
//|    acknowledgement to Vladislav Goshkov (VG) - 4vg@mail.ru       |
//|                      && Alex.Piech.FinGeR for the major MM lines |
//|    acknowledgement to xard777@connectfree.co.uk for the routine  |
//|    to show the minor lines.                                      |
//|                                                                  |
//|      code changes to show the last bar arrow if StepBack > 0     |
//|      and to change position of MM text on MM lines               |
//|                                            10/04/09  DA          |
//+------------------------------------------------------------------+
#property copyright "Vladislav Goshkov (VG) && Alex.Piech.FinGeR && xard777@connectfree.co.uk"
#property link      "4vg@mail.ru && regnif@gmx.net && xard777@connectfree.co.uk"
#property indicator_chart_window

// ============================================================================================
// * Line 8/8 & 0/8 (Ultimate Support and Ultimate Resistance).
// * Those lines are the most strong concerning Support and Resistance.
// ============================================================================================
//* Line 7/8  (Weak, Place to Stop and Reverse).
//* This line is weak. If suddenly the price was going too fast and too far and stops around this line 
//* it means the price will reverse down very soon. If the price did not stop near this line, this price 
//* will continue the movement to the line 8/8.
// ============================================================================================
//* Line 1/8  (Weak, Place to Stop and Reverse).
//* This line is weak. If suddenly the price was going too fast and too far and stops around this line 
//* it means the price will reverse up very soon. If the price did not stop near this line, this price
//* will continue the movement down to the line 0/8.
// ============================================================================================
//* Line 2/8 and 6/8 (Pivot, Reverse)
//* Those two lines yield the line 4/8 only to the strength to reverse the price movement.
// ============================================================================================
//* Line 5/8 (Top of Trading Range)
//* The price is spending the about 40% of the time on the movement between the lines 5/8 and 3/8. 
//* If the price is moving near line 5/8 and stopping near the line during the 10 - 12 days, so it means 
//* that it is necessary to sell in this "bonus zone" (some people are doing like this) but if the price
//* is keeping the tendency to stay above the 5/8 line, so it means that the price will be above. 
//* But if the price is droping below 5/8 line it means that the price will continue falling 
//* to the next level of resistance.
// ============================================================================================
//* Line 3/8 (Bottom of Trading Range).
//* If the price is below this line and in uptrend it means that it will be very difficult for the price
//* to break this level. 
//* If the price broke this line during the uptrend and staying above during the 10 12 days it means that
//* the price will be above this line during the 40% of its time moving between this line and 5/8 line.
// ============================================================================================
//* Line 4/8 (Major Support/Resistance Line).
//* It is the major line concerning support and resistance.
//* This level is the better for the new sell or buy. 
//* It is the strong level of support of the price is above 4/8. It is the fine resistance line
//* if the price is below this 4/8 line. 
// ============================================================================================
extern int P = 64;  
extern int MMPeriod = 60;
extern int StepBack = 0;
extern int text_shift = 16;  // name changed from mml_shft and externalised - DA
extern bool verbose = true;  // nice to be able to choose - DA
extern bool ShowMinorLines = false;  // acknowledgement to xard777@connectfree.co.uk
extern bool color.frame=false;   // ex Shamus
extern bool ShowTF = true;       // new (just for Shamus)
extern int TFCorner= 2;
extern color TFColour=Yellow;

extern color  mml_clr_m_2_8 = White;       // [-2]/8
extern color  mml_clr_m_1_8 = Magenta;       // [-1]/8
extern color  mml_clr_0_8   = DeepSkyBlue;        //  [0]/8
extern color  mml_clr_1_8   = Gold;      //  [1]/8
extern color  mml_clr_2_8   = Tomato;         //  [2]/8
extern color  mml_clr_3_8   = Lime;       //  [3]/8
extern color  mml_clr_4_8   = Aqua;        //  [4]/8
extern color  mml_clr_5_8   = Lime;       //  [5]/8
extern color  mml_clr_6_8   = Tomato;         //  [6]/8
extern color  mml_clr_7_8   = Gold;      //  [7]/8
extern color  mml_clr_8_8   = DeepSkyBlue;        //  [8]/8
extern color  mml_clr_p_1_8 = Magenta;       // [+1]/8
extern color  mml_clr_p_2_8 = White;       // [+2]/8

extern int    mml_wdth_m_2_8 = 2;        // [-2]/8
extern int    mml_wdth_m_1_8 = 2;       // [-1]/8
extern int    mml_wdth_0_8   = 2;        //  [0]/8
extern int    mml_wdth_1_8   = 2;      //  [1]/8
extern int    mml_wdth_2_8   = 2;         //  [2]/8
extern int    mml_wdth_3_8   = 2;       //  [3]/8
extern int    mml_wdth_4_8   = 2;        //  [4]/8
extern int    mml_wdth_5_8   = 2;       //  [5]/8
extern int    mml_wdth_6_8   = 2;         //  [6]/8
extern int    mml_wdth_7_8   = 2;      //  [7]/8
extern int    mml_wdth_8_8   = 2;        //  [8]/8
extern int    mml_wdth_p_1_8 = 2;       // [+1]/8
extern int    mml_wdth_p_2_8 = 2;       // [+2]/8

extern color  MarkColor   = Aqua;
extern int    MarkNumber  = 217;

extern color MM1Color = C'0,6,60';
extern color MM2Color = C'100,5,60';
extern color MM3Color = C'0,6,60';
//+------------------------------------------------------------------+
#define FF1 "FF1"
#define FF2 "FF2"
#define FF3 "FF3"
#define FF4 "FF4"
#define FF5 "FF5"
#define Xdb "Xdb"
#define Ydb "Ydb"
//+------------------------------------------------------------------+ 

// minor lines
double v45=0;
double mml00=0,mml0=0,mml1=0,mml2=0,mml3=0,mml4=0,mml5=0,mml6=0,mml7=0,mml8=0,mml9=0,mml98=0,mml99=0;
double mm92=0,mm94=0,mm96=0,mm82=0,mm84=0,mm86=0,mm72=0,mm74=0,mm76=0,mm62=0,mm64=0,mm66=0,mm56=0,mm54=0;
double mm52=0,mm46=0,mm44=0,mm42=0,mm36=0,mm34=0,mm32=0,mm26=0,mm24=0,mm22=0,mm16=0,mm14=0,mm12s=0,mm06=0;
double mm04=0,mm02=0,mm106=0,mm104=0,mm102=0,mm1006=0,mm1004=0,mm1002=0;

double  dmml = 0,
        dvtl = 0,
        sum  = 0,
        v1 = 0,
        v2 = 0,
        mn = 0,
        mx = 0,
        x1 = 0,
        x2 = 0,
        x3 = 0,
        x4 = 0,
        x5 = 0,
        x6 = 0,
        y1 = 0,
        y2 = 0,
        y3 = 0,
        y4 = 0,
        y5 = 0,
        y6 = 0,
        octave = 0,
        fractal = 0,
        range   = 0,
        finalH  = 0,
        finalL  = 0,
        mml[13];

string  TFScreen = "",
        ln_txt[13],
        minor_lines[36],       
        buff_str = "",
        editor="Grath 1.23";
        
int     TF = 0,
        bn_v1   = 0,
        bn_v2   = 0,
        OctLinesCnt = 13,
        MinorLinesCnt = 36,
        // mml_thk = 8,
        mml_clr[13],
        mml_wdth[13],
        nTime = 0,
        CurPeriod = 0,
        nDigits = 0,
        i = 0;
int     NewPeriod=0;
int     FrameWidth=10;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
//+------------------------------------------------------------------+ 
   

//---- indicators  IndicatorCounted
   if(MMPeriod>0)
      NewPeriod   = P*MathCeil(MMPeriod/Period());
   else NewPeriod = P;
 
   FrameWidth=Bars;
  
   if(verbose) { 
   ln_txt[0]  = "Extreme Overshoot  -2/8";// "Extreme overshoot [-2/8]";// [-2/8]
   ln_txt[1]  = "Overshoot  -1/8 ";// "Overshoot [-1/8]";// [-1/8]
   ln_txt[2]  = "Ultimate Support - Extremely Oversold  0/8";// "Ultimate Support - Extremely Oversold [0/8]";// [0/8]
   ln_txt[3]  = "Weak, Place to Stop and Reverse  1/8";// "Weak, Place to Stop and Reverse - [1/8]";// [1/8]
   ln_txt[4]  = "Strong, Pivot, Reverse  2/8";// "Strong, Pivot, Reverse [2/8]";// [2/8]
   ln_txt[5]  = "Bottom of Trading Range  3/8";// "Bottom of Trading Range - [3/8], if 10-12 bars then 40% Time. BUY Premium Zone";//[3/8]
   ln_txt[6]  = "Major Support/Resistance Pivotal Point  4/8";// "Major Support/Resistance Pivotal Point [4/8]- Best New BUY or SELL level";// [4/8]
   ln_txt[7]  = "Top of Trading Range  5/8";// "Top of Trading Range - [5/8], if 10-12 bars then 40% Time. SELL Premium Zone";//[5/8]
   ln_txt[8]  = "Strong, Pivot, Reverse  6/8";// "Strong, Pivot, Reverse [6/8]";// [6/8]
   ln_txt[9]  = "Weak, Place to Stop and Reverse  7/8";// "Weak, Place to Stop and Reverse - [7/8]";// [7/8]
   ln_txt[10] = "Ultimate Resistance - Extremely Overbought  8/8";// "Ultimate Resistance - Extremely Overbought [8/8]";// [8/8]
   ln_txt[11] = "Overshoot  +1/8";// "Overshoot [+1/8]";// [+1/8]
   ln_txt[12] = "Extreme Overshoot  +2/8";// "Extreme Overshoot [+2/8]";// [+2/8]
   }
   else {
   ln_txt[0]  = "[-2/8]";
   ln_txt[1]  = "[-1/8]";
   ln_txt[2]  = "[0/8]";  
   ln_txt[3]  = "[1/8]";
   ln_txt[4]  = "[2/8]";// [2/8]
   ln_txt[5]  = "[3/8]";//[3/8]
   ln_txt[6]  = "[4/8]";// [4/8]
   ln_txt[7]  = "[5/8]";//[5/8]
   ln_txt[8]  = "[6/8]";// [6/8]
   ln_txt[9]  = "[7/8]";// [7/8]
   ln_txt[10] = "[8/8]";// [8/8]
   ln_txt[11] = "[+1/8]";// [+1/8]
   ln_txt[12] = "[+2/8]";// [+2/8]
   }


   mml_clr[0]  = mml_clr_m_2_8;   mml_wdth[0] = mml_wdth_m_2_8; // [-2]/8
   mml_clr[1]  = mml_clr_m_1_8;   mml_wdth[1] = mml_wdth_m_1_8; // [-1]/8
   mml_clr[2]  = mml_clr_0_8;     mml_wdth[2] = mml_wdth_0_8;   //  [0]/8
   mml_clr[3]  = mml_clr_1_8;     mml_wdth[3] = mml_wdth_1_8;   //  [1]/8
   mml_clr[4]  = mml_clr_2_8;     mml_wdth[4] = mml_wdth_2_8;   //  [2]/8
   mml_clr[5]  = mml_clr_3_8;     mml_wdth[5] = mml_wdth_3_8;   //  [3]/8
   mml_clr[6]  = mml_clr_4_8;     mml_wdth[6] = mml_wdth_4_8;   //  [4]/8
   mml_clr[7]  = mml_clr_5_8;     mml_wdth[7] = mml_wdth_5_8;   //  [5]/8
   mml_clr[8]  = mml_clr_6_8;     mml_wdth[8] = mml_wdth_6_8;   //  [6]/8
   mml_clr[9]  = mml_clr_7_8;     mml_wdth[9] = mml_wdth_7_8;   //  [7]/8
   mml_clr[10] = mml_clr_8_8;     mml_wdth[10]= mml_wdth_8_8;   //  [8]/8
   mml_clr[11] = mml_clr_p_1_8;   mml_wdth[11]= mml_wdth_p_1_8; // [+1]/8
   mml_clr[12] = mml_clr_p_2_8;   mml_wdth[12]= mml_wdth_p_2_8; // [+2]/8
   
   
   minor_lines[0] = "mm1002";
   minor_lines[1] = "mm1004";
   minor_lines[2] = "mm1006";
   minor_lines[3] = "mm102";
   minor_lines[4] = "mm104";
   minor_lines[5] = "mm106";
   minor_lines[6] = "mm02";
   minor_lines[7] = "mm04";
   minor_lines[8] = "mm06";
   minor_lines[9] = "mm12s";
   minor_lines[10] = "mm14";
   minor_lines[11] = "mm16";
   minor_lines[12] = "mm22";
   minor_lines[13] = "mm24";
   minor_lines[14] = "mm26";
   minor_lines[15] = "mm32";
   minor_lines[16] = "mm34";
   minor_lines[17] = "mm36";
   minor_lines[18] = "mm42";
   minor_lines[19] = "mm44";
   minor_lines[20] = "mm46";
   minor_lines[21] = "mm52";
   minor_lines[22] = "mm54";
   minor_lines[23] = "mm56";
   minor_lines[24] = "mm62";
   minor_lines[25] = "mm64";
   minor_lines[26] = "mm66";
   minor_lines[27] = "mm72";
   minor_lines[28] = "mm74";
   minor_lines[29] = "mm76";
   minor_lines[30] = "mm82";
   minor_lines[31] = "mm84";
   minor_lines[32] = "mm86";
   minor_lines[33] = "mm92";
   minor_lines[34] = "mm94";
   minor_lines[35] = "mm96";

   
   
//----
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit() {
//---- TODO: add your code here

Comment(" ");   
for(i=0;i<OctLinesCnt;i++) {
    buff_str = "mml"+i;
    ObjectDelete(buff_str);
    buff_str = "mml_txt"+i;
    ObjectDelete(buff_str);
    }
    buff_str = "MML_LatestCalcBar";  // RDA 09/04/09 This taken OUT of the For loop to stop other
    ObjectDelete(buff_str);          // screen objects being deleted when indicator removed.
for(i=0;i<MinorLinesCnt;i++) {
    buff_str = minor_lines[i];
    ObjectDelete(buff_str);
    }
    //---- Screen Background
   ObjectDelete(FF1);
   ObjectDelete(FF2);
   ObjectDelete(FF3);
   ObjectDelete(FF4);
   ObjectDelete(FF5);
//----
    //---- TimeFrame
   ObjectDelete(Xdb);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {

//---- TODO: add your code here


if( (nTime != Time[0]) || (CurPeriod != Period()) ) {
   
  //price
   bn_v1 = Lowest(NULL,0,MODE_LOW,NewPeriod+StepBack,StepBack);
   bn_v2 = Highest(NULL,0,MODE_HIGH,NewPeriod+StepBack,StepBack);

   v1 = Low[bn_v1];
   v2 = High[bn_v2];

//determine fractal.....
   if( v2<=250000 && v2>25000 )
   fractal=100000;
   else
     if( v2<=25000 && v2>2500 )
     fractal=10000;
     else
       if( v2<=2500 && v2>250 )
       fractal=1000;
       else
         if( v2<=250 && v2>25 )
         fractal=100;
         else
           if( v2<=25 && v2>12.5 )
           fractal=12.5;
           else
             if( v2<=12.5 && v2>6.25)
             fractal=12.5;
             else
               if( v2<=6.25 && v2>3.125 )
               fractal=6.25;
               else
                 if( v2<=3.125 && v2>1.5625 )
                 fractal=3.125;
                 else
                   if( v2<=1.5625 && v2>0.390625 )
                   fractal=1.5625;
                   else
                     if( v2<=0.390625 && v2>0)
                     fractal=0.1953125;
      
   range=(v2-v1);
   sum=MathFloor(MathLog(fractal/range)/MathLog(2));
   octave=fractal*(MathPow(0.5,sum));
   mn=MathFloor(v1/octave)*octave;
   if( (mn+octave)>v2 )
   mx=mn+octave; 
   else
     mx=mn+(2*octave);


// calculating xx
//x2
    if( (v1>=(3*(mx-mn)/16+mn)) && (v2<=(9*(mx-mn)/16+mn)) )
    x2=mn+(mx-mn)/2; 
    else x2=0;
//x1
    if( (v1>=(mn-(mx-mn)/8))&& (v2<=(5*(mx-mn)/8+mn)) && (x2==0) )
    x1=mn+(mx-mn)/2; 
    else x1=0;

//x4
    if( (v1>=(mn+7*(mx-mn)/16))&& (v2<=(13*(mx-mn)/16+mn)) )
    x4=mn+3*(mx-mn)/4; 
    else x4=0;

//x5
    if( (v1>=(mn+3*(mx-mn)/8))&& (v2<=(9*(mx-mn)/8+mn))&& (x4==0) )
    x5=mx; 
    else  x5=0;

//x3
    if( (v1>=(mn+(mx-mn)/8))&& (v2<=(7*(mx-mn)/8+mn))&& (x1==0) && (x2==0) && (x4==0) && (x5==0) )
    x3=mn+3*(mx-mn)/4; 
    else x3=0;

//x6
    if( (x1+x2+x3+x4+x5) ==0 )
    x6=mx; 
    else x6=0;

     finalH = x1+x2+x3+x4+x5+x6;
// calculating yy
//y1
    if( x1>0 )
    y1=mn; 
    else y1=0;

//y2
    if( x2>0 )
    y2=mn+(mx-mn)/4; 
    else y2=0;

//y3
    if( x3>0 )
    y3=mn+(mx-mn)/4; 
    else y3=0;

//y4
    if( x4>0 )
    y4=mn+(mx-mn)/2; 
    else y4=0;

//y5
    if( x5>0 )
    y5=mn+(mx-mn)/2; 
    else y5=0;

//y6
    if( (finalH>0) && ((y1+y2+y3+y4+y5)==0) )
    y6=mn; 
    else y6=0;

    finalL = y1+y2+y3+y4+y5+y6;

    for( i=0; i<OctLinesCnt; i++) {
         mml[i] = 0;
         }
         
   dmml = (finalH-finalL)/8;
   v45 = dmml;

   mml[0] =(finalL-dmml*2); //-2/8
   for( i=1; i<OctLinesCnt; i++) {
        mml[i] = mml[i-1] + dmml;
        }
   for( i=0; i<OctLinesCnt; i++ ){
        buff_str = "mml"+i;
        if(ObjectFind(buff_str) == -1) {
           ObjectCreate(buff_str, OBJ_HLINE , 0,Time[0], mml[i]);
           ObjectSet(buff_str, OBJPROP_STYLE, STYLE_SOLID);
           ObjectSet(buff_str, OBJPROP_COLOR, mml_clr[i]);
           ObjectSet(buff_str, OBJPROP_WIDTH, mml_wdth[i]);
           ObjectMove(buff_str, 0, Time[0],  mml[i]);
           }
        else {
           ObjectMove(buff_str, 0, Time[0],  mml[i]);
           }
            
        buff_str = "mml_txt"+i;
        if(ObjectFind(buff_str) == -1) {
           ObjectCreate(buff_str, OBJ_TEXT, 0, Time[text_shift], text_shift);
           ObjectSetText(buff_str, ln_txt[i]+"  ("+DoubleToStr(mml[i],Digits)+")", 8, "Arial", mml_clr[i]);
           ObjectMove(buff_str, 0, Time[text_shift],  mml[i]);
           }
        else {
           ObjectMove(buff_str, 0, Time[text_shift],  mml[i]);
           }
        } // for( i=1; i<=OctLinesCnt; i++ ){

   if (ShowMinorLines){
      //Sub 2/8th, 4/8th, & 6/8th Lines
      mm1002=(finalL-1.25*v45); mm1004=(finalL-1.5*v45); mm1006=(finalL-1.75*v45); mm102=(finalL-0.25*v45);
      mm104=(finalL-0.5*v45); mm106=(finalL-0.75*v45); mm02=(finalL+0.25*v45); mm04=(finalL+0.5*v45);
      mm06=(finalL+0.75*v45); mm12s=(finalL+1.25*v45); mm14=(finalL+1.5*v45); mm16=(finalL+1.75*v45);
      mm22=(finalL+2.25*v45); mm24=(finalL+2.5*v45); mm26=(finalL+2.75*v45); mm32=(finalL+3.25*v45);
      mm34=(finalL+3.5*v45); mm36=(finalL+3.75*v45); mm42=(finalL+4.25*v45); mm44=(finalL+4.5*v45);
      mm46=(finalL+4.75*v45); mm52=(finalL+5.25*v45); mm54=(finalL+5.5*v45); mm56=(finalL+5.75*v45);
      mm62=(finalL+6.25*v45); mm64=(finalL+6.5*v45); mm66=(finalL+6.75*v45); mm72=(finalL+7.25*v45);
      mm74=(finalL+7.5*v45); mm76=(finalL+7.75*v45); mm82=(finalL+8.25*v45); mm84=(finalL+8.5*v45);
      mm86=(finalL+8.75*v45); mm92=(finalL+9.25*v45); mm94=(finalL+9.5*v45); mm96=(finalL+9.75*v45);

      ObjectCreate("mm1002" ,OBJ_HLINE,0,Time[0],mm1002,Time[0],mm1002); 
      ObjectSet("mm1002",OBJPROP_COLOR,SlateGray);ObjectSet("mm1002",OBJPROP_WIDTH,1);ObjectSet("mm1002",OBJPROP_STYLE, STYLE_SOLID);
      ObjectMove("mm1002", 0, Time[text_shift],  mm1002);

      ObjectCreate("mm1004" ,OBJ_HLINE,0,Time[0],mm1004,Time[0],mm1004); 
      ObjectSet("mm1004",OBJPROP_COLOR,SlateGray);ObjectSet("mm1004",OBJPROP_WIDTH,1);ObjectSet("mm1004",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm1006" ,OBJ_HLINE,0,Time[0],mm1006,Time[0],mm1006); 
      ObjectSet("mm1006",OBJPROP_COLOR,SlateGray);ObjectSet("mm1006",OBJPROP_WIDTH,1);ObjectSet("mm1006",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm102" ,OBJ_HLINE,0,Time[0],mm102,Time[0],mm102); 
      ObjectSet("mm102",OBJPROP_COLOR,SlateGray);ObjectSet("mm102",OBJPROP_WIDTH,1);ObjectSet("mm102",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm104" ,OBJ_HLINE,0,Time[0],mm104,Time[0],mm104); 
      ObjectSet("mm104",OBJPROP_COLOR,SlateGray);ObjectSet("mm104",OBJPROP_WIDTH,1);ObjectSet("mm104",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm106" ,OBJ_HLINE,0,Time[0],mm106,Time[0],mm106); 
      ObjectSet("mm106",OBJPROP_COLOR,SlateGray);ObjectSet("mm106",OBJPROP_WIDTH,1);ObjectSet("mm106",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm02" ,OBJ_HLINE,0,Time[0],mm02,Time[0],mm02); 
      ObjectSet("mm02",OBJPROP_COLOR,SlateGray);ObjectSet("mm02",OBJPROP_WIDTH,1);ObjectSet("mm02",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm04" ,OBJ_HLINE,0,Time[0],mm04,Time[0],mm04); 
      ObjectSet("mm04",OBJPROP_COLOR,SlateGray);ObjectSet("mm04",OBJPROP_WIDTH,1);ObjectSet("mm04",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm06" ,OBJ_HLINE,0,Time[0],mm06,Time[0],mm06); 
      ObjectSet("mm06",OBJPROP_COLOR,SlateGray);ObjectSet("mm06",OBJPROP_WIDTH,1);ObjectSet("mm06",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm12s" ,OBJ_HLINE,0,Time[0],mm12s,Time[0],mm12s); 
      ObjectSet("mm12s",OBJPROP_COLOR,SlateGray);ObjectSet("mm12s",OBJPROP_WIDTH,1);ObjectSet("mm12s",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm14" ,OBJ_HLINE,0,Time[0],mm14,Time[0],mm14); 
      ObjectSet("mm14",OBJPROP_COLOR,SlateGray);ObjectSet("mm14",OBJPROP_WIDTH,1);ObjectSet("mm14",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm16" ,OBJ_HLINE,0,Time[0],mm16,Time[0],mm16); 
      ObjectSet("mm16",OBJPROP_COLOR,SlateGray);ObjectSet("mm16",OBJPROP_WIDTH,1);ObjectSet("mm16",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm22" ,OBJ_HLINE,0,Time[0],mm22,Time[0],mm22); 
      ObjectSet("mm22",OBJPROP_COLOR,SlateGray);ObjectSet("mm22",OBJPROP_WIDTH,1);ObjectSet("mm22",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm24" ,OBJ_HLINE,0,Time[0],mm24,Time[0],mm24); 
      ObjectSet("mm24",OBJPROP_COLOR,SlateGray);ObjectSet("mm24",OBJPROP_WIDTH,1);ObjectSet("mm24",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm26" ,OBJ_HLINE,0,Time[0],mm26,Time[0],mm26); 
      ObjectSet("mm26",OBJPROP_COLOR,SlateGray);ObjectSet("mm26",OBJPROP_WIDTH,1);ObjectSet("mm26",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm32" ,OBJ_HLINE,0,Time[0],mm32,Time[0],mm32); 
      ObjectSet("mm32",OBJPROP_COLOR,SlateGray);ObjectSet("mm32",OBJPROP_WIDTH,1);ObjectSet("mm32",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm34" ,OBJ_HLINE,0,Time[0],mm34,Time[0],mm34); 
      ObjectSet("mm34",OBJPROP_COLOR,SlateGray);ObjectSet("mm34",OBJPROP_WIDTH,1);ObjectSet("mm34",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm36" ,OBJ_HLINE,0,Time[0],mm36,Time[0],mm36); 
      ObjectSet("mm36",OBJPROP_COLOR,SlateGray);ObjectSet("mm36",OBJPROP_WIDTH,1);ObjectSet("mm36",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm42" ,OBJ_HLINE,0,Time[0],mm42,Time[0],mm42); 
      ObjectSet("mm42",OBJPROP_COLOR,SlateGray);ObjectSet("mm42",OBJPROP_WIDTH,1);ObjectSet("mm42",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm44" ,OBJ_HLINE,0,Time[0],mm44,Time[0],mm44); 
      ObjectSet("mm44",OBJPROP_COLOR,SlateGray);ObjectSet("mm44",OBJPROP_WIDTH,1);ObjectSet("mm44",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm46" ,OBJ_HLINE,0,Time[0],mm46,Time[0],mm46); 
      ObjectSet("mm46",OBJPROP_COLOR,SlateGray);ObjectSet("mm46",OBJPROP_WIDTH,1);ObjectSet("mm46",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm52" ,OBJ_HLINE,0,Time[0],mm52,Time[0],mm52); 
      ObjectSet("mm52",OBJPROP_COLOR,SlateGray);ObjectSet("mm52",OBJPROP_WIDTH,1);ObjectSet("mm52",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm54" ,OBJ_HLINE,0,Time[0],mm54,Time[0],mm54); 
      ObjectSet("mm54",OBJPROP_COLOR,SlateGray);ObjectSet("mm54",OBJPROP_WIDTH,1);ObjectSet("mm54",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm56" ,OBJ_HLINE,0,Time[0],mm56,Time[0],mm56); 
      ObjectSet("mm56",OBJPROP_COLOR,SlateGray);ObjectSet("mm56",OBJPROP_WIDTH,1);ObjectSet("mm56",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm62" ,OBJ_HLINE,0,Time[0],mm62,Time[0],mm62); 
      ObjectSet("mm62",OBJPROP_COLOR,SlateGray);ObjectSet("mm62",OBJPROP_WIDTH,1);ObjectSet("mm62",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm64" ,OBJ_HLINE,0,Time[0],mm64,Time[0],mm64); 
      ObjectSet("mm64",OBJPROP_COLOR,SlateGray);ObjectSet("mm64",OBJPROP_WIDTH,1);ObjectSet("mm64",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm66" ,OBJ_HLINE,0,Time[0],mm66,Time[0],mm66); 
      ObjectSet("mm66",OBJPROP_COLOR,SlateGray);ObjectSet("mm66",OBJPROP_WIDTH,1);ObjectSet("mm66",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm72" ,OBJ_HLINE,0,Time[0],mm72,Time[0],mm72); 
      ObjectSet("mm72",OBJPROP_COLOR,SlateGray);ObjectSet("mm72",OBJPROP_WIDTH,1);ObjectSet("mm72",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm74" ,OBJ_HLINE,0,Time[0],mm74,Time[0],mm74); 
      ObjectSet("mm74",OBJPROP_COLOR,SlateGray);ObjectSet("mm74",OBJPROP_WIDTH,1);ObjectSet("mm74",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm76" ,OBJ_HLINE,0,Time[0],mm76,Time[0],mm76); 
      ObjectSet("mm76",OBJPROP_COLOR,SlateGray);ObjectSet("mm76",OBJPROP_WIDTH,1);ObjectSet("mm76",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm82" ,OBJ_HLINE,0,Time[0],mm82,Time[0],mm82); 
      ObjectSet("mm82",OBJPROP_COLOR,SlateGray);ObjectSet("mm82",OBJPROP_WIDTH,1);ObjectSet("mm82",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm84" ,OBJ_HLINE,0,Time[0],mm84,Time[0],mm84); 
      ObjectSet("mm84",OBJPROP_COLOR,SlateGray);ObjectSet("mm84",OBJPROP_WIDTH,1);ObjectSet("mm84",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm86" ,OBJ_HLINE,0,Time[0],mm86,Time[0],mm86); 
      ObjectSet("mm86",OBJPROP_COLOR,SlateGray);ObjectSet("mm86",OBJPROP_WIDTH,1);ObjectSet("mm86",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm92" ,OBJ_HLINE,0,Time[0],mm92,Time[0],mm92); 
      ObjectSet("mm92",OBJPROP_COLOR,SlateGray);ObjectSet("mm92",OBJPROP_WIDTH,1);ObjectSet("mm92",OBJPROP_STYLE, STYLE_SOLID);

      ObjectCreate("mm94" ,OBJ_HLINE,0,Time[0],mm94,Time[0],mm94); 
      ObjectSet("mm94",OBJPROP_COLOR,SlateGray);ObjectSet("mm94",OBJPROP_WIDTH,1);ObjectSet("mm94",OBJPROP_STYLE, STYLE_DOT);

      ObjectCreate("mm96" ,OBJ_HLINE,0,Time[0],mm96,Time[0],mm96); 
      ObjectSet("mm96",OBJPROP_COLOR,SlateGray);ObjectSet("mm96",OBJPROP_WIDTH,1);ObjectSet("mm96",OBJPROP_STYLE, STYLE_SOLID);
      } // end if ShowMinorLines

 //+------------------------------------------------------------------+  
     if (color.frame) {  
         FrameWidth=Bars;
         CreateObj(FF1, mml[5], mml[7], MM1Color);
         ObjectMove(FF1, 1, Time[0], mml[7] );
         CreateObj(FF2, mml[0], mml[2], MM2Color);
         ObjectMove(FF2, 1, Time[0], mml[2] );
         CreateObj(FF3, mml[10],mml[12], MM2Color);
         ObjectMove(FF3, 1, Time[0], mml[12] );
         CreateObj(FF4, mml[7], mml[10], MM3Color);
         ObjectMove(FF4, 1, Time[0], mml[10] );
         CreateObj(FF5, mml[2], mml[5], MM3Color); 
         ObjectMove(FF5, 1, Time[0], mml[5] );
      } // end if color.frame 
       

      if (ShowTF) {
         TFScreen = "MMPeriod=" + MMPeriod ;
         ObjectCreate("Xdb", OBJ_LABEL, 0, 0, 0);
         ObjectSetText("Xdb", TFScreen, 12, "Gungsuh", TFColour);
         ObjectSet("Xdb", OBJPROP_CORNER, TFCorner);
         ObjectSet("Xdb", OBJPROP_XDISTANCE,  60);
         ObjectSet("Xdb", OBJPROP_YDISTANCE,  5);  
      }  // end if ShowTF   
     
      ObjectCreate("Ydb", OBJ_LABEL, 0, 0, 0);
      ObjectSetText("Ydb", editor, 8, "Gungsuh", TFColour);
      ObjectSet("Ydb", OBJPROP_CORNER, 2);
      ObjectSet("Ydb", OBJPROP_XDISTANCE,  0);
      ObjectSet("Ydb", OBJPROP_YDISTANCE,  5);  

//+------------------------------------------------------------------+  

      nTime    = Time[0];
      CurPeriod= Period();
 
 //  This bit made a conditional instead of being commented out - DA
 //    Only show the arrow if we are stepping back!     
      if(StepBack>0) {
         string buff_str = "MML_LatestCalcBar";
         if(ObjectFind(buff_str) == -1) {
         ObjectCreate(buff_str, OBJ_ARROW,0, Time[StepBack], Low[StepBack]-2*Point );
         ObjectSet(buff_str, OBJPROP_ARROWCODE, MarkNumber);
         ObjectSet(buff_str, OBJPROP_COLOR, MarkColor);
         }
      else {
         ObjectMove(buff_str, 0, Time[StepBack], Low[StepBack]-2*Point );
         }
      }  //  end if StepBack
   }  //  end if( (nTime != Time[0]) || (CurPeriod != Period()) )
 
//---- End Of Program
  return(0);
}
  
     void CreateObj(string objName, double bottom, double top, color clr)
   {
   //ObjectCreate(objName, OBJ_RECTANGLE, 0, Time[0+FrameWidth], bottom, Time[0], top);
   ObjectCreate(objName, OBJ_RECTANGLE, 0, iTime(NULL,CurPeriod,P), bottom, Time[0], top);
   ObjectSet(objName, OBJPROP_COLOR, clr);
   }

//+------------------------------------------------------------------+
   //ObjectCreate(objName, OBJ_RECTANGLE, 0, iTime(NULL,CurPeriod,P), start, Time[0], end);

