            //+------------------------------------------------------------------+
//|                                                  NSNDHistory.mq4 |
//|                      Copyright  2011, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
extern int barcount=500;
extern int NSNDcount=10;
string comment[10];
static int prevtime=0;
static int prevfirstbar=0;
static double prevpricemax=0;
#property indicator_chart_window
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------0-----------------------------+
int init()
  {
//---- indicators
f_clear();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   f_clear();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {

   int    counted_bars=IndicatorCounted();
   string Bull_or_Bear,obj_nameND;
   bool Low_Volume,Pins,Bear_Close_Below,Bull_Close_Above,Bear_Close_Above,Bull_Close_Below;
   string label;
   double chartheight=WindowPriceMax()-WindowPriceMin();
   double addhigh=6.00/100.00*chartheight;
//   Comment(WindowFirstVisibleBar(),"  ",prevfirstbar);
//----
  if(WindowFirstVisibleBar()!=prevfirstbar)
  {
   prevtime=0;
  }
  if(WindowPriceMax()!=prevpricemax)
  {
   prevtime=0;
  }
 
  if(Time[0]!=prevtime) // | prevfirstbar!=WindowFirstVisibleBar())// && 11==2)
  {
   f_clear();
  //for(int i=barcount;i>=1;i--)
   for(int i=WindowFirstVisibleBar();i>=WindowFirstVisibleBar()-500 && i>0 ;i--)
   {
    Bull_or_Bear=f_Bull_or_Bear(i);
    Low_Volume=f_Low_Volume(i);
    Pins=f_Pins(i,Bull_or_Bear);
  //  Comment(Bull_or_Bear," Low Volume ",Low_Volume,"  Pins ",Pins );
         Bear_Close_Below=false;
       Bear_Close_Above=false;
       Bull_Close_Above=false;
       Bull_Close_Below=false;
    for(int ix=i;ix>i-NSNDcount && ix>0;ix--)
    {
       if(Bull_or_Bear=="Bear" && Close[ix]<Low[i] && !Bear_Close_Above)
       {
         Bear_Close_Below=true;
       }
       if(Bull_or_Bear=="Bear" && Close[ix]>High[i] && !Bear_Close_Below)
       {
         Bear_Close_Above=true;
       }
       if(Bull_or_Bear=="Bull" && Close[ix]>High[i] && !Bear_Close_Below)
       {
         Bull_Close_Above=true;
        }
       if(Bull_or_Bear=="Bull" && Close[ix]<Low[i] && !Bear_Close_Above)
       {
         Bull_Close_Below=true;
       }
    }//end for ix  
    label=TimeYear(Time[i])+DoubleToStr(TimeMonth(Time[i]),0)+DoubleToStr(TimeDay(Time[i]),0);
    label=label+DoubleToStr(TimeHour(Time[i]),0)+DoubleToStr(TimeMinute(Time[i]),0);  
    if(Bull_or_Bear=="Bull" && Low_Volume && Pins && !Bull_Close_Above && Bull_Close_Below)
    {
      obj_nameND="No Demand - "+i+" - "+label;
      ObjectCreate(obj_nameND,OBJ_TEXT,0,Time[i],High[i]+(addhigh));//+spread+0.0005);
      ObjectSetText(obj_nameND,"v",18,"Arial",Pink);
      ObjectSet(obj_nameND,OBJPROP_PRICE1,High[i]+(addhigh));
      ObjectSet(obj_nameND,OBJPROP_TIME1,Time[i]);
      if(High[i]-Close[i]>Open[i]-Low[i])
      {
        ObjectSetText(obj_nameND,"v",18,"Arial",Red);
     }
    }
    if(Bull_or_Bear=="Bear" && Low_Volume && Pins && !Bear_Close_Below  && Bear_Close_Above)
    {
       string obj_nameNS="No Supply - "+i+" - "+label;
       ObjectCreate(obj_nameNS,OBJ_TEXT,0,Time[i],Low[i]);//-spread-0.0005);
       ObjectSetText(obj_nameNS,"^",22,"Arial",LightGreen);
       ObjectSet(obj_nameNS,OBJPROP_PRICE1,Low[i]);
       ObjectSet(obj_nameNS,OBJPROP_TIME1,Time[i]);
       if(High[i]-Open[i]<Close[i]-Low[i])
       {
       ObjectSetText(obj_nameNS,"^",18,"Arial",Green);
       }
    }
    
   }//end for i 
   prevtime=Time[0];
   prevfirstbar=WindowFirstVisibleBar();
   prevpricemax=WindowPriceMax();
   }//endif if prevtime
//---- 

   return(0);
  }
  
string f_Bull_or_Bear(int i)
{
 string retvar;
    if(Open[i]>Close[i])
   {
       retvar="Bear";
       comment[i]=comment[i]+"Bear ";
   }
   if(Close[i]>Open[i])
   {
    retvar="Bull";
    comment[i]=comment[i]+"Bull ";
   }
 return(retvar);
}

bool f_Low_Volume(int i)
{
  bool retvar=False;
     if(Volume[i]<Volume[i+1] && Volume[i]<Volume[i+2])
     {
       retvar=True;
       comment[i]=comment[i]+"Low Vol ";
    }
 return(retvar);
}

bool f_Pins(int i,string Bull_or_Bear)
{
  bool Pins=false;
  double pip=Point*1;
  bool retval;
  if(Bull_or_Bear=="Bear" && High[i]>Open[i]+pip && Low[i]<Close[i]-pip)
  {
    retval=true;
    comment[i]=comment[i]+" Pins";
  }
  if(Bull_or_Bear=="Bull" && High[i]>Close[i]+pip && Low[i]<Open[i]-pip)
  {
    retval=true;
    comment[i]=comment[i]+" Pins";
  }
  return(retval);
}

void f_clear()
{
  for (int i=ObjectsTotal(); i>0; i--)
  
 {
   if(StringSubstr(ObjectName(i),0,2)=="No")
   {
    ObjectDelete(ObjectName(i));
   }
 }
   for (i=ObjectsTotal(); i>0; i--)
  
 {
   if(StringSubstr(ObjectName(i),0,2)=="No")
   {
    ObjectDelete(ObjectName(i));
   }
 }
}
//+------------------------------------------------------------------+