#property copyright	"Copyright  2014, Alexander Elgin"
#property link		"alexmost113@mail.ru"

#property version "1.10"
#property indicator_chart_window
#property indicator_buffers	0

#include <graphical.mqh>
#include <handlers.mqh>

#define LEVELS_NUMBER 3
#define SEMAPHORE_NAME "MA Flat"
#define SEMAPHORE_OFFSET_X 30
#define SEMAPHORE_OFFSET_Y 30
#define SEMAPHORE_SIZE 20

#define DISTANCE_NAME "Distance"
#define FONT_SIZE 14

input int PeriodMA = 14;
input int ShiftMA = 0;
input ENUM_MA_METHOD MethodMA = MODE_SMA;
input ENUM_APPLIED_PRICE PriceMA = PRICE_CLOSE;
input double Distance = 0.00005;
input int disatnce_label_offset_x = 80;
input int disatnce_label_offset_y = 10;

double ma_buffer[];
int ma_handler, prev_value = -1;

int OnInit() {
	SetIndexBuffer(0, ma_buffer, INDICATOR_DATA);
	ArraySetAsSeries(ma_buffer, true);
	
	ma_handler = getFullMaHandler(PeriodMA, ShiftMA, MethodMA, PriceMA);
	if(ma_handler <= 0) return(0);
	
	createLabelWithBackground(SEMAPHORE_NAME, "", Red, Red, ANCHOR_RIGHT_UPPER, CORNER_RIGHT_UPPER, SEMAPHORE_OFFSET_X, SEMAPHORE_OFFSET_Y, SEMAPHORE_SIZE, SEMAPHORE_SIZE);
	createLabel(DISTANCE_NAME, "", Black, ANCHOR_RIGHT_LOWER, CORNER_RIGHT_LOWER, disatnce_label_offset_x, disatnce_label_offset_y);

	IndicatorSetString(INDICATOR_SHORTNAME, "50SMAIntraScalp");
	return(INIT_SUCCEEDED);
}
  
int OnCalculate(const int rates_total, const int prev_calculated, const datetime &time[], const double &open[], const double &high[],
				const double &low[], const double &close[], const long &tick_volume[], const long &volume[], const int &spread[]) {
	
	if((ma_handler <= 0) || (BarsCalculated(ma_handler) < LEVELS_NUMBER) || (CopyBuffer(ma_handler, 0, 0, rates_total, ma_buffer) < LEVELS_NUMBER)) return -1;
	
	int current_value = getCloseLevelMA(ma_buffer, Distance);
	if(current_value != prev_value) Alert(SEMAPHORE_NAME + ": the color has become " + getColorName(current_value));
	
	ObjectSetInteger(0, SEMAPHORE_NAME, OBJPROP_BGCOLOR, getObjectColor(current_value));
	prev_value = current_value;

	double ask = SymbolInfoDouble(Symbol(), SYMBOL_ASK);
	double bid = SymbolInfoDouble(Symbol(), SYMBOL_BID);

	if(bid > ma_buffer[0]) setDistance(bid - ma_buffer[0], Blue);
	if(ask < ma_buffer[0]) setDistance(ma_buffer[0] - ask, Red);

	return rates_total;
}

void OnDeinit(const int reason) {
	ObjectDelete(0, SEMAPHORE_NAME);
	ObjectDelete(0, DISTANCE_NAME);
}

color getObjectColor(int index) {
	color colors[LEVELS_NUMBER] = {Red, Orange, Green};
	return colors[index + 1];
}

string getColorName(int index) {
	string colors[LEVELS_NUMBER] = {"red", "orange", "green"};
	return colors[index + 1];
}

int getCloseLevelMA(double &values[], double distance) {
	if(MathAbs(values[0] - values[1]) <= distance)
		return (MathAbs(values[0] - values[2]) <= distance) && (MathAbs(values[1] - values[2]) <= distance) ? 1 : 0;
	return -1;
}

void setDistance(double value, color label_color) {
	ObjectSetInteger(0, DISTANCE_NAME, OBJPROP_COLOR, label_color);
	ObjectSetString(0, DISTANCE_NAME, OBJPROP_TEXT, "DISTANCE: " + DoubleToString(value, Digits()));
}
