//+------------------------------------------------------------------+
//|                                EA codeCopyright  2012 Jim Bentz |
//|                                       j.bentz@jbentz.net         |
//|                                                                  |
//|                                    System Logic Copyright  2012 |
//|               http://forums.babypips.com/members/windsorftw.html |
//+------------------------------------------------------------------+
#property copyright "Copyright  2012 Jim Bentz"

#import "kernel32.dll"
int SystemTimeToFileTime(int& TimeArray[], int& FileTimeArray[]);
int FileTimeToLocalFileTime(int& FileTimeArray[], int& LocalFileTimeArray[]);
void GetSystemTime(int& TimeArray[]);
#import

//---- input parameters
extern   int        Use_CloseAll_for_netPips         = false;
extern   double      CloseAll_net_pips                = 200.0;
//-------------------EA RetraceBox inputs-----------------
extern   int         MagicNumber                      = 342890342890;
extern   string      TradeComment                     = "Wicked Wicks";
extern   string      s1;
extern   bool        Allow_EA_Trades                  = true;
extern   bool        Trade_Monday                     = true;
extern   bool        MondayGapProtection              = false;
extern   double      MondayGap                        = 30;
extern   bool        Trade_Friday                     = true;
extern   bool        CloseWinnersOnFriday             = false;
extern   bool        CloseAllTradesOnFriday           = false;
//   string      UTC_Time_For_Friday_Close        = "20:45";
extern   int         Local_Hour_To_Close_Friday       = 13;
extern   bool        NonHedging                       = true;
extern   double      MaxSpread                        = 5;
extern   bool        Max_1_trade_per_day              = true;
extern   string      s2;
extern   double      Min_Wick_Size_prev_candle        = 0;
extern   double      Min_Fibo_Size_pips               = 40;
extern   bool        Use_ATR_for_fibo_size            = false;
extern   double      Fibo_Size_pips_ATR_Ratio         = 0.6;
extern   color       FibLongColor                     = Green;
extern   color       FibLongText                      = Green;
extern   color       FibShortColor                    = Red;
extern   color       FibShortText                     = Red;
//---------------set fib tp sl percent values--------------
extern   string      s6;
extern   double      SL_Fib_Pct                       = 23.2;
extern   double      Entry_Fib_Pct                    = 110;
extern   bool        UseBreakEven                     = true;
extern   double      BreakEven_Profit_Pips            = 0;
extern   double      BreakEven_Fib_Pct                = 131.8;
extern   double      TP_Fib_Pct                       = 400;
extern   bool        Use_ATR_Multi_for_settings       = false;
extern   double      Fibo_Settings_ATR_Ratio          = 0.4;
extern   int         Fib_SL_Levels_max6               = 3;
extern   double      SL_Level1_Fib_Pct                = 161.8;
extern   double      SL_Level2_Fib_Pct                = 200;
extern   double      SL_Level3_Fib_Pct                = 300;
extern   double      SL_Level4_Fib_Pct                = 0;
extern   double      SL_Level5_Fib_Pct                = 0;
extern   double      SL_Level6_Fib_Pct                = 0;
extern   string      s15                              = "Set additional fib stop-step levels";
extern   string      s16                              = "by increasing number>3, and change the";
extern   string      s17                              = "Fib_Pct numbers to fit your preference.";
extern   string      s18                              = "Default is as Windsor specified.";
extern   string      s14;
extern   bool        Use_FibStep_TrailingStop         = true;
extern   bool        Use_Standard_TrailingStop        = false;
extern   double      TrailingStop_Pips                = 25;
extern   double      TrailingStop_StartProfit_Pips    = 20;
extern   string      s12                              = "set SwingSL_CandlesBack = 0 >> not used";
extern   string      s13                              = "set SwingSL_CandlesBack > 0 >> in use";
extern   int         SwingSL_CandlesBack              = 0;
extern   bool        Trail_SwingSL                    = false;
extern   bool        Use_2x_SL_for_TP                 = false;
extern   string      s3;
extern   int         CandlesBetweenTrades             = 0;
         int         TradeBar,BuyTradeBar,SellTradeBar;

//==================lot/risk calculation inputs==============         
extern   string      s                                ="Note: Leave lots=0 to use RiskPercent calc";         
extern   double      lots                             = 0;
extern   bool        Use_StopLoss_4_risk_calc         = true;
extern   double      RiskPercent                      = 1;
extern   bool        UseAllOpenTrades4Risk            = true;
extern   int         MaxTrades                        = 6;
extern   double      MaxLots                          = 3;

         double      Lots,AmountAtRisk,PointCostValue,point;
         string      Lot,SymbolExtra,Currency;
         
//-----------moving average channel----------
extern   bool        Use_MA_Channel_Filter            = true;
extern   int         MA_Channel_Period                = 5;
extern   int         MA_Channel_Mode                  = MODE_SMMA;
//================================================================
extern   bool        debug                            = false;
extern   bool        Show_Comments                    = false;
         bool        long=false;
         bool        short=false;
         bool        TradingOk=false;


     
         string      StatusComment,cmt1,cmt2,debug1,debug2,debug3,debug4,
                     cmtlong,cmtshort,
                     cmtlots,cmtstoplosspips,
                     cmtrsi,cmtstoch,
                     cmtdaily,
                     cmtlongcandles,cmtshortcandles,
                     cmtmachannel,cmtfibosize,
                     cmtspread,cmttrademonday,cmttradefriday,cmttradesperday,
                     FiltersComment,DebugComments,
                     TradingStopTime;
                     
         double      DigitsMulti,spread,stoplevel,StopLossPips;

         double      longSL,longSL1,longSL2,longSL3,longSL4,longSL5,longSL6,longTP,
                     shortSL,shortSL1,shortSL2,shortSL3,shortSL4,shortSL5,shortSL6,shortTP,
                     shortBE,longBE,
                     shortDelta,longDelta,
                     longEntry,shortEntry,
                     atr,adj,MA_High,MA_Low,
                     prevLongSL,prevShortSL,
                     buyprofit,sellprofit,TotalNetPips;
         
         int         i,j,k,l,m,t,buys,sells,buystops,sellstops,OpenOrders,ticket,Total_EA_Trades,prevTotal_EA_Trades,
                     prevBuyBar,prevSellBar,buystopticket,sellstopticket,buyticket,sellticket,
                     longbar,shortbar,prevBuyBar1,prevSellBar1,prevshortSL,
                     shortbar1,longbar1,checkedBuyBar,checkedSellBar,
                     checkedlong,checkedshort,bar,longsent,shortsent,
                     checklong,checkshort,lastHistoryTrade,process;
         
         datetime    t1,t2,BuyOpenTime,SellOpenTime,buystopOpenTime,sellstop,sellstopOpenTime,lastHistoryTime;
         
         double      p1,p2,openprice,takeprofit;    
         
         datetime    OpenPlatformTime;
         
         // reference
         //   0 OP_BUY - buying position,
         //   1 OP_SELL - selling position,
         //   2 OP_BUYLIMIT - buy limit pending position,
         //   3 OP_BUYSTOP - buy stop pending position,
         //   4 OP_SELLLIMIT - sell limit pending position,
         //   5 OP_SELLSTOP - sell stop pending position.
         


int init()
{
   ////////  GET SETTINGS FOR BROKER  ////////
   Print("lotsize ",MarketInfo(Symbol(),MODE_LOTSIZE));
   Print("lotstep ",MarketInfo(Symbol(),MODE_LOTSTEP));
   Print("minlot ",MarketInfo(Symbol(),MODE_MINLOT));
   Print("maxlot ",MarketInfo(Symbol(),MODE_MAXLOT));
   Print("stoplevel ",MarketInfo(Symbol(),MODE_STOPLEVEL));   
   Print("spread ",MarketInfo(Symbol(),MODE_SPREAD));   
   ///////////////////////////////////////////
   //TradeComment=TradeComment+Period(); 
   if(Digits==3||Digits==5)DigitsMulti=10;else DigitsMulti=1;
   
   //-------setting all pip inputs to price point values------
   adj=Point*DigitsMulti;
   
   BreakEven_Profit_Pips            *= adj;
   Min_Fibo_Size_pips               *= adj;
   Min_Wick_Size_prev_candle        *= adj;
   MondayGap                        *= adj;
   point                            =  adj;
   MaxSpread                        *= DigitsMulti;
   TrailingStop_Pips                *= adj;
   TrailingStop_StartProfit_Pips    *= adj;
   CloseAll_net_pips                *= adj;
   
   BreakEven_Fib_Pct                *= 0.01;
   Entry_Fib_Pct                    *= 0.01;
   SL_Fib_Pct                       *= 0.01;
   SL_Level1_Fib_Pct                *= 0.01;
   SL_Level2_Fib_Pct                *= 0.01;
   SL_Level3_Fib_Pct                *= 0.01;
   SL_Level4_Fib_Pct                *= 0.01;
   SL_Level5_Fib_Pct                *= 0.01;
   SL_Level6_Fib_Pct                *= 0.01;
   TP_Fib_Pct                       *= 0.01;

   spread=MarketInfo(Symbol(),MODE_SPREAD)*Point;
   stoplevel=MarketInfo(Symbol(),MODE_STOPLEVEL)*Point;
   //---------------------------------------------------------
   
   
   ObjectDelete("LongFibo");
   ObjectDelete("ShortFibo");
   
   ObjectDelete("EntryLong");
   ObjectDelete("BELong");
   ObjectDelete("TPLong");
   ObjectDelete("SLLong");
   
   ObjectDelete("EntryLongtxt");
   ObjectDelete("BELongtxt");
   ObjectDelete("TPLongtxt");
   ObjectDelete("SLLongtxt");
   
   ObjectDelete("EntryShort");
   ObjectDelete("BEShort");
   ObjectDelete("TPShort");
   ObjectDelete("SLShort");
   
   ObjectDelete("EntryShorttxt");
   ObjectDelete("BEShorttxt");
   ObjectDelete("TPShorttxt");
   ObjectDelete("SLShorttxt");
   
   for(i=1;i<=6;i++)
   {
      ObjectDelete("SL"+i+"Long");
      ObjectDelete("SL"+i+"Short");
      ObjectDelete("SL"+i+"Longtxt");
      ObjectDelete("SL"+i+"Shorttxt");
   }
   
   Comment("");
   cmtshort="";
   cmtlong="";
   
   CheckOpenOrders();
   prevTotal_EA_Trades=Total_EA_Trades;
   OpenPlatformTime=TimeCurrent();
   long=false;
   short=false;
   TradingOk=false;
   process=0;
 
}

int deinit()
{
   Comment("");
   cmtshort="";
   cmtlong="";
   
   ObjectDelete("LongFibo");
   ObjectDelete("ShortFibo");
   
   ObjectDelete("EntryLong");
   ObjectDelete("BELong");
   ObjectDelete("TPLong");
   ObjectDelete("SLLong");
   
   ObjectDelete("EntryLongtxt");
   ObjectDelete("BELongtxt");
   ObjectDelete("TPLongtxt");
   ObjectDelete("SLLongtxt");
   
   ObjectDelete("EntryShort");
   ObjectDelete("BEShort");
   ObjectDelete("TPShort");
   ObjectDelete("SLShort");
   
   ObjectDelete("EntryShorttxt");
   ObjectDelete("BEShorttxt");
   ObjectDelete("TPShorttxt");
   ObjectDelete("SLShorttxt");
   
   for(i=1;i<=6;i++)
   {
      ObjectDelete("SL"+i+"Long");
      ObjectDelete("SL"+i+"Short");
      ObjectDelete("SL"+i+"Longtxt");
      ObjectDelete("SL"+i+"Shorttxt");
   }
}
//==================================================================================     

//==================================================================================       
int start()
{
   CheckOpenOrders();
   if(Use_CloseAll_for_netPips && TotalNetPips>=CloseAll_net_pips)
   {
      CloseAllOrders(OP_BUY);
      CloseAllOrders(OP_SELL);
      CheckOpenOrders();
   }
   if(buys>0||sells>0)CheckStops();
      
   ////////causes all functions below to update only once per new candle
   if(process==Bars)return;
   if(Max_1_trade_per_day)process=Bars;
   
   atr=iATR(Symbol(),0,14,0);
   
   if(Use_ATR_for_fibo_size)Min_Fibo_Size_pips=Fibo_Size_pips_ATR_Ratio*atr;
   
   ////////////if refreshing or reopening charts, redraw fib lines and tp/sl on chart///////////
   CheckFiboLong();
   CheckFiboShort();
   
   //long=TradingConditions(OP_BUY);
   //short=TradingConditions(OP_SELL);
   
   long=true;
   if(!isOutside_MA_Channel(OP_BUY))long=false;
   if(!IsGoodCandlePattern(OP_BUY))long=false;
   if(!IsSufficientFiboSize(OP_BUY))long=false;
   if(!IsGoodPriceLevel(OP_BUY))long=false;
   if(!(Bars-BuyTradeBar>=CandlesBetweenTrades))long=false;
   if(!NoOpenTrades(OP_BUY))long=false;
   if(!NoPreviousTradesToday() && Max_1_trade_per_day)long=false;
   if(!Allow_EA_Trades)long=false;
   if(!Total_EA_Trades<MaxTrades)long=false;
   
   short=true;
   if(!isOutside_MA_Channel(OP_SELL))short=false;
   if(!IsGoodCandlePattern(OP_SELL))short=false;
   if(!IsSufficientFiboSize(OP_SELL))short=false;
   if(!IsGoodPriceLevel(OP_SELL))short=false;
   if(!(Bars-SellTradeBar>=CandlesBetweenTrades))short=false;
   if(!NoOpenTrades(OP_SELL))short=false;
   if(!NoPreviousTradesToday() && Max_1_trade_per_day)short=false;
   if(!Allow_EA_Trades)short=false;
   if(!Total_EA_Trades<MaxTrades)short=false;
   /*
   if(!Show_Comments && !debug)
      Comment(   
   
         "\nlong\n"+(!isOutside_MA_Channel(OP_BUY))
         +"\n"+(!IsGoodCandlePattern(OP_BUY))
         +"\n"+(!IsSufficientFiboSize(OP_BUY))
         +"\n"+(!IsGoodPriceLevel(OP_BUY))
         +"\n"+(!(Bars-BuyTradeBar>=CandlesBetweenTrades))
         +"\n"+(!NoOpenTrades(OP_BUY))
         +"\n"+(!NoPreviousTradesToday() && Max_1_trade_per_day)
         +"\n"+(!Allow_EA_Trades)
         +"\n"+(!Total_EA_Trades<MaxTrades)
         +"\n\nlong = "+long
   
         +"\n\nshort\n"+(!isOutside_MA_Channel(OP_SELL))
         +"\n"+(!IsGoodCandlePattern(OP_SELL))
         +"\n"+(!IsSufficientFiboSize(OP_SELL))
         +"\n"+(!IsGoodPriceLevel(OP_SELL))
         +"\n"+(!(Bars-SellTradeBar>=CandlesBetweenTrades))
         +"\n"+(!NoOpenTrades(OP_SELL))
         +"\n"+(!NoPreviousTradesToday() && Max_1_trade_per_day)
         +"\n"+(!Allow_EA_Trades)
         +"\n"+(!Total_EA_Trades<MaxTrades)
         +"\n\nshort = "+short
   
      );
   */
   TradingLimiters();
      
   if(debug||Show_Comments)CommentManagement();
      
   if(!TradingOk)return;
   
   ///////////////check conditions for opening long pending trade//////////////
   if(Close[1]>Open[1])
   {    
      cmtshort="";
      cmtshortcandles="";
      
      if(sellstops>0 && NonHedging)CloseAllOrders(OP_SELLSTOP);      
      
      //CheckFiboLong();
      
      if(long)
      {
      
         if(Total_EA_Trades!=prevTotal_EA_Trades && UseAllOpenTrades4Risk)
         {
            if(buystops>0)CloseAllOrders(OP_BUYSTOP);
            if(sellstops>0)CloseAllOrders(OP_SELLSTOP);
            prevTotal_EA_Trades=Total_EA_Trades;
         }
         OpenLongTrade();
      }
   }
   ///////////////check conditions for opening short pending trade//////////////
   if(Close[1]<Open[1])// && Bars!=shortbar)
   {
      cmtlong="";
      cmtlongcandles="";
      
      if(buystops>0 && NonHedging)CloseAllOrders(OP_BUYSTOP);
          
      //CheckFiboShort();  
      
      if(short)
      {
         {
            if(buystops>0)CloseAllOrders(OP_BUYSTOP);
            if(sellstops>0)CloseAllOrders(OP_SELLSTOP);
            prevTotal_EA_Trades=Total_EA_Trades;
         }
         OpenShortTrade();
      }
   }
   ////////////adjusting new lot size for increasing multiple trades to mitigate litera. multiple
   ////////////of risk specified.  Decreases risk by dividing specified by number of open orders
   ////////////including the order about to be opened
   if(Show_Comments)
   if(OpenOrders>0)
   {
      if(!UseAllOpenTrades4Risk || Total_EA_Trades==1)
      {
         cmtstoplosspips="\n                                                StopLossPips = "+DoubleToStr(StopLossPips,0)
            +"\n                                                PointCost = "+DoubleToStr(PointCost(),5)
            +"\n                                                Each pip will be "+DoubleToStr(PointCost()*lotCalculator(),Digits);
      }
      else if(UseAllOpenTrades4Risk && Total_EA_Trades>1)
      {       
         cmtstoplosspips="\n                                                \n                                                UseAllOpenTrades4Risk=True, so with "+(Total_EA_Trades-1)+" open trades,"
            +"\n                                                risk per trade has been reduced from "+DoubleToStr(RiskPercent,2)+" to "+DoubleToStr(RiskPercent/Total_EA_Trades,2)
            +"\n                                                \n                                                StopLossPips = "+DoubleToStr(StopLossPips,0)
            +"\n                                                PointCost = "+DoubleToStr(PointCost(),5)
            +"\n                                                Each pip will be "+DoubleToStr(PointCost()*lotCalculator(),Digits);
     }
     else
     cmtstoplosspips="";
   }
   
   
   return;
   
}

/////////////////boolean filter for limiting trades per day to one or multiple//////////////
bool NoPreviousTradesToday()
{
   for(k=OrdersHistoryTotal()-1;k>=0;k--)
   {
      OrderSelect(k,SELECT_BY_POS,MODE_HISTORY);
      
      if
      (
         OrderMagicNumber()==MagicNumber
         &&
         OrderSymbol()==Symbol()
         &&
         OrderType()<2
         &&
         TimeDayOfYear(OrderCloseTime())==TimeDayOfYear(TimeCurrent())
      )
      {
         if(Show_Comments)
         cmttradesperday=("\n                                                One trade has completed already today."
                         +"\n                                                OneTradePerDay selected.  No more trades today.");
         return(false);
         break;
      }
      else
      cmttradesperday="";
   }
   return(true);
}

datetime GetLastOpenTradeTime(int type)
{   
   for(k=OrdersTotal()-1;k>=0;k--)
   {
      OrderSelect(k,SELECT_BY_POS,MODE_TRADES);
      
      if
      (
         OrderMagicNumber()==MagicNumber
         &&
         OrderSymbol()==Symbol()
         &&
         OrderType()==type
       
      )
      { 
         return(OrderOpenTime());
         break;
      }
   }
   
   return(0);
}

/////////////////tally numbers for open orders/////////////
bool CheckOpenOrders()
{
  
   buys=0;
   sells=0;
   buystops=0;
   sellstops=0;
   OpenOrders=0;
   Total_EA_Trades=1;
   TotalNetPips=0;
   
   buystopticket=0;
   sellstopticket=0;
   
   buyprofit=0;
   sellprofit=0;
   
   for(int q=0;q<OrdersTotal();q++)
   {
      OrderSelect(q,SELECT_BY_POS,MODE_TRADES);
      
      if
      (
         OrderMagicNumber()==MagicNumber
         && OrderSymbol()==Symbol()
      )
      {  
         if(OrderType()==OP_BUY)
         {
            buys++;
            buyprofit=OrderProfit();
         }
         if(OrderType()==OP_SELL)
         {
            sells++;
            sellprofit=OrderProfit();
         }            
         if(OrderType()==OP_BUYSTOP)
         {
            buystops++;
         }
         if(OrderType()==OP_SELLSTOP)
         {
            sellstops++;
         }
         OpenOrders++;  
      } 
      
      if
      (
         OrderMagicNumber()==MagicNumber
         && OrderSymbol()!=Symbol()
         && OrderType()<2
      )
      {  
         Total_EA_Trades++;
      }
      
      if(OrderMagicNumber()==MagicNumber)
      {
         if(OrderType()==OP_BUY)TotalNetPips+=(MarketInfo(OrderSymbol(),MODE_BID)-OrderOpenPrice());
         if(OrderType()==OP_SELL)TotalNetPips+=(OrderOpenPrice()-MarketInfo(OrderSymbol(),MODE_ASK));
      }
   }
   
  return;       
}

///////////////////trailing stop step function if orders are in profit/////////////////
void CheckStops()
{
   //adjusting stoploss points for each trade depending on profit levels 
   for(int t=0;t<OrdersTotal();t++)
   {
      OrderSelect(t,SELECT_BY_POS,MODE_TRADES);
      
      if
      (
         OrderMagicNumber()==MagicNumber
         && OrderSymbol()==Symbol()
         && OrderType()<2
         && OrderProfit()>0
      )
      {   
        
         ////////////////////////long trades//////////////////////
         
         if(UseBreakEven && OrderType()==OP_BUY)
         {
            double beLong_hline = NormalizeDouble(OrderOpenPrice()+BreakEven_Profit_Pips,Digits);
            TrailingStop("beLong_hline",OP_BUY,beLong_hline-OrderCommission(), longBE);
         }
         if(Use_FibStep_TrailingStop)
         {
            if(Fib_SL_Levels_max6>=1 && OrderType()==OP_BUY)TrailingStop("longBE",OP_BUY,longBE, longSL1);
            if(Fib_SL_Levels_max6>=2 && OrderType()==OP_BUY)TrailingStop("longSL1",OP_BUY,longSL1, longSL2);
            if(Fib_SL_Levels_max6>=3 && OrderType()==OP_BUY)TrailingStop("longSL2",OP_BUY,longSL2, longSL3);
            if(Fib_SL_Levels_max6>=4 && OrderType()==OP_BUY)TrailingStop("longSL3",OP_BUY,longSL3, longSL4);
            if(Fib_SL_Levels_max6>=5 && OrderType()==OP_BUY)TrailingStop("longSL4",OP_BUY,longSL4, longSL5);
            if(Fib_SL_Levels_max6>=6 && OrderType()==OP_BUY)TrailingStop("longSL5",OP_BUY,longSL5, longSL6);
   
         }  
         if(Use_Standard_TrailingStop)
         {
            double tsLong=NormalizeDouble(MarketInfo(Symbol(),MODE_BID)-TrailingStop_Pips,Digits);
        
        
            if
            (
               OrderType()==OP_BUY  && buys==1 
               &&
               ((MarketInfo(Symbol(),MODE_BID)-OrderOpenPrice())/adj > TrailingStop_StartProfit_Pips)
               && (
                     (UseBreakEven && MarketInfo(Symbol(),MODE_BID)>OrderOpenPrice()+TrailingStop_Pips+BreakEven_Profit_Pips-OrderCommission())
                     ||
                     (!UseBreakEven && MarketInfo(Symbol(),MODE_BID)>OrderOpenPrice()+TrailingStop_Pips)
                  )
               && OrderStopLoss()<MarketInfo(Symbol(),MODE_BID)-TrailingStop_Pips 
            )
            if(!OrderModify(OrderTicket(),OrderOpenPrice(),tsLong,OrderTakeProfit(),0,Blue))
            {
               Comment("Unable to move tsLong to "+tsLong+" error "+GetLastError());
            }
         }
         //////////////////short trades//////////////// 
         
          
         if(UseBreakEven && OrderType()==OP_SELL)
         {
            double beShort_hline = NormalizeDouble(OrderOpenPrice()-BreakEven_Profit_Pips,Digits);
            TrailingStop("beShort_hline",OP_SELL,beShort_hline+OrderCommission(), shortBE);
         }
         if(Use_FibStep_TrailingStop)
         {
            if(Fib_SL_Levels_max6>=1 && OrderType()==OP_SELL)TrailingStop("shortBE",OP_SELL,shortBE, shortSL1);
            if(Fib_SL_Levels_max6>=2 && OrderType()==OP_SELL)TrailingStop("shortSL1",OP_SELL,shortSL1, shortSL2);
            if(Fib_SL_Levels_max6>=3 && OrderType()==OP_SELL)TrailingStop("shortSL2",OP_SELL,shortSL2, shortSL3);
            if(Fib_SL_Levels_max6>=4 && OrderType()==OP_SELL)TrailingStop("shortSL3",OP_SELL,shortSL3, shortSL4);
            if(Fib_SL_Levels_max6>=5 && OrderType()==OP_SELL)TrailingStop("shortSL4",OP_SELL,shortSL4, shortSL5);
            if(Fib_SL_Levels_max6>=6 && OrderType()==OP_SELL)TrailingStop("shortSL5",OP_SELL,shortSL5, shortSL6);
         }
         if(Use_Standard_TrailingStop)
         {
            double tsShort=NormalizeDouble(MarketInfo(Symbol(),MODE_ASK)+TrailingStop_Pips,Digits);
       
       
            if
            (
               OrderType()==OP_SELL  && sells==1 
               &&
               ((OrderOpenPrice()-MarketInfo(Symbol(),MODE_ASK))/adj > TrailingStop_StartProfit_Pips)
               && (
                     (UseBreakEven && MarketInfo(Symbol(),MODE_ASK)<OrderOpenPrice()-TrailingStop_Pips-BreakEven_Profit_Pips+OrderCommission())
                     ||
                     (!UseBreakEven && MarketInfo(Symbol(),MODE_ASK)<OrderOpenPrice()-TrailingStop_Pips)
                  )
               && OrderStopLoss()>MarketInfo(Symbol(),MODE_ASK)+TrailingStop_Pips 
            )
            if(!OrderModify(OrderTicket(),OrderOpenPrice(),tsShort,OrderTakeProfit(),0,Red))
            {
               Comment("Unable to move tsShort to "+tsShort+" error "+GetLastError());
            }
         }
         
         //if using pending orders to enter trade, this will cancel any remaining once trade opens
         if((buys>0 || sells>0) && OrderType()>1)
            if(NonHedging)OrderDelete(OrderTicket());
      }   
   }  
}   
         
void TrailingStop(string name, int dir,double to, double at)
{
   /*
   ObjectCreate(name,OBJ_HLINE,0,0,0);
   if(dir==OP_BUY)
      ObjectSet(name,OBJPROP_COLOR,Green);
   else
      ObjectSet(name,OBJPROP_COLOR,Red);
      ObjectSet(name,OBJPROP_WIDTH,3);
   ObjectMove(name,0,Time[0],to);
   
   ObjectCreate(name,OBJ_HLINE,0,0,0);
   if(dir==OP_BUY)
      ObjectSet(name,OBJPROP_COLOR,Green);
   else
      ObjectSet(name,OBJPROP_COLOR,Red);
      ObjectSet(name,OBJPROP_WIDTH,3);
   ObjectMove(name,0,Time[0],at);
   */
   if
   (
      dir==OP_BUY
      && MarketInfo(Symbol(),MODE_BID)>=at
      && to<=at-stoplevel 
      && OrderStopLoss()<to
   )
   OrderModify(OrderTicket(),OrderOpenPrice(),to,OrderTakeProfit(),0,Blue);
      
   if
   (
      dir==OP_SELL
      && MarketInfo(Symbol(),MODE_BID)<=at
      && to>=at+stoplevel+spread
      && OrderStopLoss()>to
   )
   OrderModify(OrderTicket(),OrderOpenPrice(),to,OrderTakeProfit(),0,Blue);
}         

////////////determine candle for drawing fib and calculating fib values for tp/sl/////
////////////uses other functions to determine/////////////////////////////////////////
void CheckFiboLong()
{     
      datetime longtime;
      longbar=1;
      longbar1=1;
      
      if(buystops>0)longtime=GetLastOpenTradeTime(OP_BUYSTOP);
      if(buys>0)longtime=GetPendingOpenTime(OP_BUYSTOP);
      if(buys>0 && longtime==0)longtime=GetLastOpenTradeTime(OP_BUY);
      if(longtime!=0)
      {
         if(longtime!=0)
         {
            for(i=0;i<100;i++)
            {
               if(Time[i]>longtime)
               {
                  longbar++;
               }
               else
               break;
            }
         }
      }
      
      if(Show_Comments)
      debug3="\n                                                longtime "+longtime+" "+TimeToStr(longtime)  
            +"\n                                                longbar1 "+longbar1+"  longbar "+longbar;
            
      
      if(longbar>longbar1)longbar1=longbar;
      if(IsGoodCandlePattern(OP_BUY)&&buys==0)longbar1=1;
        
      if(IsGoodCandlePattern(OP_BUY) || buys>0 || buystops>0)CreatFibs(OP_BUY);
      
      int tkt=GetOrderTicket(OP_BUYSTOP);
      OrderSelect(tkt,SELECT_BY_TICKET,MODE_TRADES);
      
      if
      (
         buystops>0 && IsGoodCandlePattern(OP_BUY) && buys==0
         &&
         (
            (GetPendingOpenTime(OP_BUYSTOP)!=Time[0])
            ||
            (
               longEntry>OrderOpenPrice()+stoplevel
               ||
               longEntry<OrderOpenPrice()-stoplevel
               ||
               longSL>OrderStopLoss()+stoplevel
               ||
               longSL<OrderStopLoss()-stoplevel
               ||
               longTP>OrderTakeProfit()+stoplevel
               ||
               longTP<OrderTakeProfit()-stoplevel
            )
         )
      )
      {
         if(OrderModify(GetOrderTicket(OP_BUYSTOP),longEntry,longSL,longTP,0,Blue))
         {
            longsent = SetPendingOpenTime(OP_BUYSTOP,Time[0]);
            Print("FiboLong modify order to new fib");
         }
         else
         {
            Print(
               "Unable to modify order to new fib "
               +" orderticket "+GetOrderTicket(OP_BUYSTOP)
               +" longentry "+longEntry
               +" longSL "+longSL
               +" longTP "+longTP
               +" error# "+GetLastError()
            );
         }
      }
      if(Trail_SwingSL && buys>0 && buyprofit<0 && longSL!=prevLongSL)
      {     
         if(OrderModify(GetOrderTicket(OP_BUY),OrderOpenPrice(),longSL,OrderTakeProfit(),0,Blue))
         {
            Print("FiboLong modify order to new SwingSL");
            prevLongSL=longSL;
         }
         else
         {
            Print(GetLastError());
         }
      }
}
        
void CheckFiboShort()
{     
      datetime shorttime;
      shortbar=1;
      shortbar1=1;
      
      if(sellstops>0)shorttime=GetLastOpenTradeTime(OP_SELLSTOP);
      if(sells>0)shorttime=GetPendingOpenTime(OP_SELLSTOP);
      if(sells>0 && shorttime==0)shorttime=GetLastOpenTradeTime(OP_SELL);
      if(shorttime!=0)
      {
      
         for(i=0;i<100;i++)
         {
            if(Time[i]>shorttime)
            {
               shortbar++;
            }
            else
            break;
         }
      }
      
      if(debug)
         debug4="\n                                                shorttime "+shorttime+" "+TimeToStr(shorttime)
               +"\n                                                shortbar1 "+shortbar1+"  shortbar "+shortbar;
      
      //if(sells>0 && 
      if(shortbar>shortbar1)shortbar1=shortbar;
      if(IsGoodCandlePattern(OP_SELL)&&sells==0)shortbar1=1;
      
      if(IsGoodCandlePattern(OP_SELL) || sells>0 || sellstops>0)CreatFibs(OP_SELL);
      
      int tkt=GetOrderTicket(OP_SELLSTOP);
      OrderSelect(tkt,SELECT_BY_TICKET,MODE_TRADES);
      
      if
      (
         sellstops>0 && IsGoodCandlePattern(OP_SELL) && sells==0
         &&
         (
            (GetPendingOpenTime(OP_SELLSTOP)!=Time[0])
            ||
            (
               shortEntry>OrderOpenPrice()+stoplevel
               ||
               shortEntry<OrderOpenPrice()-stoplevel
               ||
               shortSL>OrderStopLoss()+stoplevel
               ||
               shortSL<OrderStopLoss()-stoplevel
               ||
               shortTP>OrderTakeProfit()+stoplevel
               ||
               shortTP<OrderTakeProfit()-stoplevel
            )
         )
      )
      {
         if(OrderModify(GetOrderTicket(OP_SELLSTOP),shortEntry,shortSL,shortTP,0,Red))
         {
            shortsent = SetPendingOpenTime(OP_SELLSTOP,Time[0]);
            Print("FiboShort modify order to new fib");
         }
         else
         {
            Print(
               "Unable to modify order to new fib "
               +" orderticket "+GetOrderTicket(OP_SELLSTOP)
               +" shortentry "+shortEntry
               +" shortSL "+shortSL
               +" shortTP "+shortTP
               +" error# "+GetLastError()
            );
         }
      }
      
      if(Trail_SwingSL && sells>0 && sellprofit<0 && shortSL!=prevshortSL)
      {     
         OrderModify(GetOrderTicket(OP_SELL),OrderOpenPrice(),shortSL,OrderTakeProfit(),0,Red);
         prevshortSL=shortSL;
      }
}
 
void CreatFibs(int dir)
{
   if(dir==OP_BUY)
   {
      CalcFib_t1p1_t2p2(OP_BUY,longbar1);
      CalcFibValues(OP_BUY, p1, p2);
      
      MakeFib("LongFibo", FibLongColor,t1,p1,t2,p2);
   
      if(UseBreakEven)MakeLine(longBE,FibLongText,"BE","Long");
      if(Fib_SL_Levels_max6>=1)MakeLine(longSL1,FibLongText,"SL1","Long");
      if(Fib_SL_Levels_max6>=2)MakeLine(longSL2,FibLongText,"SL2","Long");
      if(Fib_SL_Levels_max6>=3)MakeLine(longSL3,FibLongText,"SL3","Long");
      if(Fib_SL_Levels_max6>=4)MakeLine(longSL4,FibLongText,"SL4","Long");
      if(Fib_SL_Levels_max6>=5)MakeLine(longSL5,FibLongText,"SL5","Long");
      if(Fib_SL_Levels_max6>=6)MakeLine(longSL6,FibLongText,"SL6","Long");
      MakeLine(longTP,FibLongText,"TP","Long");
      MakeLine(longSL,FibLongText,"SL","Long");
      MakeLine(longEntry+spread,FibLongText,"Entry","Long");
   }
   
   if(dir==OP_SELL)
   {
      CalcFib_t1p1_t2p2(OP_SELL,shortbar1);
      CalcFibValues(OP_SELL, p1, p2);
      
      MakeFib("ShortFibo", FibShortColor,t1,p1,t2,p2);
      
      if(UseBreakEven)MakeLine(shortBE,FibShortText,"BE","Short");
      if(Fib_SL_Levels_max6>=1)MakeLine(shortSL1,FibShortText,"SL1","Short");
      if(Fib_SL_Levels_max6>=2)MakeLine(shortSL2,FibShortText,"SL2","Short");
      if(Fib_SL_Levels_max6>=3)MakeLine(shortSL3,FibShortText,"SL3","Short");
      if(Fib_SL_Levels_max6>=4)MakeLine(shortSL4,FibShortText,"SL4","Short");
      if(Fib_SL_Levels_max6>=5)MakeLine(shortSL5,FibShortText,"SL5","Short");
      if(Fib_SL_Levels_max6>=6)MakeLine(shortSL6,FibShortText,"SL6","Short");
      MakeLine(shortTP,FibShortText,"TP","Short");
      MakeLine(shortSL,FibShortText,"SL","Short");
      MakeLine(shortEntry,FibShortText,"Entry","Short");
      
   } 
   
   return;  
}

void CalcFib_t1p1_t2p2(int type,int bar)
{      
   
   if(type==OP_BUY)
   {
      t1=Time[bar];
      t2=Time[bar+1];
      p1=High[bar];
      if(Use_ATR_Multi_for_settings)
         p2=p1-(Fibo_Settings_ATR_Ratio*atr);
      else
         p2=Close[bar+1];
         
      longDelta = p1-p2;
   }   
   
   if(type==OP_SELL)
   {
      t1=Time[bar];
      t2=Time[bar+1];
      p1=Low[bar];
      if(Use_ATR_Multi_for_settings)
         p2=p1+(Fibo_Settings_ATR_Ratio*atr);
      else
      p2=Close[bar+1];
   
      shortDelta = p2-p1;
   }
   
   return;
}   

void CalcFibValues(int dir, double p1, double p2)
{
   if(dir==OP_BUY)
   {
      longDelta = p1-p2;
      
      if(UseBreakEven)longBE = NormalizeDouble(p2+(BreakEven_Fib_Pct*longDelta),Digits);  
      if(Fib_SL_Levels_max6>=1)longSL1 = NormalizeDouble(p2+(SL_Level1_Fib_Pct*longDelta),Digits); 
      if(Fib_SL_Levels_max6>=2)longSL2 = NormalizeDouble(p2+(SL_Level2_Fib_Pct*longDelta),Digits);  
      if(Fib_SL_Levels_max6>=3)longSL3 = NormalizeDouble(p2+(SL_Level3_Fib_Pct*longDelta),Digits);    
      if(Fib_SL_Levels_max6>=4)longSL4 = NormalizeDouble(p2+(SL_Level4_Fib_Pct*longDelta),Digits); 
      if(Fib_SL_Levels_max6>=5)longSL5 = NormalizeDouble(p2+(SL_Level5_Fib_Pct*longDelta),Digits);     
      if(Fib_SL_Levels_max6>=6)longSL6 = NormalizeDouble(p2+(SL_Level6_Fib_Pct*longDelta),Digits);
      longEntry = NormalizeDouble(p2+(Entry_Fib_Pct*longDelta),Digits); 
      longSL = NormalizeDouble(p2+(SL_Fib_Pct*longDelta),Digits);     
      longTP = NormalizeDouble(p2+(TP_Fib_Pct*longDelta),Digits); 
      
      if(SwingSL_CandlesBack!=0)
         longSL=NormalizeDouble(Low[iLowest(Symbol(),0,MODE_LOW,SwingSL_CandlesBack,1)]-(30*Point),Digits);
         
      if(Use_2x_SL_for_TP)longTP=NormalizeDouble(longEntry+(2*(longEntry-longSL)),Digits);
      StopLossPips=(longEntry-longSL)/Point/DigitsMulti;
   }
      
   if(dir==OP_SELL)
   {
      shortDelta = p2-p1;
      
      if(UseBreakEven)shortBE = NormalizeDouble(p2-(BreakEven_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=1)shortSL1 = NormalizeDouble(p2-(SL_Level1_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=2)shortSL2 = NormalizeDouble(p2-(SL_Level2_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=3)shortSL3 = NormalizeDouble(p2-(SL_Level3_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=4)shortSL4 = NormalizeDouble(p2-(SL_Level4_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=5)shortSL5 = NormalizeDouble(p2-(SL_Level5_Fib_Pct*shortDelta),Digits);
      if(Fib_SL_Levels_max6>=6)shortSL6 = NormalizeDouble(p2-(SL_Level6_Fib_Pct*shortDelta),Digits);
      shortEntry = NormalizeDouble(p2-(Entry_Fib_Pct*shortDelta),Digits);
      shortSL = NormalizeDouble(p2-(SL_Fib_Pct*shortDelta),Digits);
      shortTP = NormalizeDouble(p2-(TP_Fib_Pct*shortDelta),Digits);
   
         
      if(SwingSL_CandlesBack!=0)
         shortSL=NormalizeDouble(High[iHighest(Symbol(),0,MODE_HIGH,SwingSL_CandlesBack,1)]+(30*Point)+spread,Digits);
         
      if(Use_2x_SL_for_TP)shortTP=NormalizeDouble(shortEntry-(2*(shortSL-shortEntry)),Digits);
      StopLossPips=(shortSL-shortEntry)/Point/DigitsMulti;
      
   }
   
   return;
}      
   
/////////////////////draw the fib based on input values/////////////////   
void MakeFib(string name, color c,datetime t1, double p1, datetime t2, double p2)
{
   ObjectCreate(name,OBJ_FIBO,0,0,0,0,0);
   if(name=="LongFibo")
      ObjectSet(name,OBJPROP_COLOR,Green);
   if(name=="ShortFibo")
      ObjectSet(name,OBJPROP_COLOR,Red);
   ObjectSet(name,OBJPROP_WIDTH,3);
   ObjectSet(name,OBJPROP_STYLE,STYLE_SOLID);
   ObjectSet(name,OBJPROP_LEVELCOLOR,c);
   ObjectSet(name,OBJPROP_FIBOLEVELS,5+Fib_SL_Levels_max6);
   
   ObjectSet(name,OBJPROP_FIRSTLEVEL,0);
   ObjectSetFiboDescription(name,0,"0  "+DoubleToStr(p2,Digits));
   
   ObjectSet(name,OBJPROP_FIRSTLEVEL+1,SL_Fib_Pct);
   if(name=="ShortFibo")
      ObjectSetFiboDescription(name,1,DoubleToStr(100*SL_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Fib_Pct*MathAbs(p1-p2)),Digits));
   if(name=="LongFibo")
      ObjectSetFiboDescription(name,1,DoubleToStr(100*SL_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Fib_Pct*MathAbs(p1-p2)),Digits));
   
   ObjectSet(name,OBJPROP_FIRSTLEVEL+2,Entry_Fib_Pct);
   if(name=="ShortFibo")
      ObjectSetFiboDescription(name,2,DoubleToStr(100*Entry_Fib_Pct,1)+"  "+DoubleToStr(p2-(Entry_Fib_Pct*MathAbs(p1-p2)),Digits));
   if(name=="LongFibo")
      ObjectSetFiboDescription(name,2,DoubleToStr(100*Entry_Fib_Pct,1)+"  "+DoubleToStr(p2+(Entry_Fib_Pct*MathAbs(p1-p2)),Digits));
   
   if(UseBreakEven)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+3,BreakEven_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,3,DoubleToStr(100*BreakEven_Fib_Pct,1)+"  "+DoubleToStr(p2-(0.01*BreakEven_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,3,DoubleToStr(100*BreakEven_Fib_Pct,1)+"  "+DoubleToStr(p2+(0.01*BreakEven_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   if(Fib_SL_Levels_max6>=1)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+4,SL_Level1_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,4,DoubleToStr(100*SL_Level1_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level1_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,4,DoubleToStr(100*SL_Level1_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level1_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   if(Fib_SL_Levels_max6>=2)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+5,SL_Level2_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,5,DoubleToStr(100*SL_Level2_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level2_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,5,DoubleToStr(100*SL_Level2_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level2_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   if(Fib_SL_Levels_max6>=3)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+6,SL_Level3_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,6,DoubleToStr(100*SL_Level3_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level3_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,6,DoubleToStr(100*SL_Level3_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level3_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   if(Fib_SL_Levels_max6>=4)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+7,SL_Level4_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,7,DoubleToStr(100*SL_Level4_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level4_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,7,DoubleToStr(100*SL_Level4_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level4_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   if(Fib_SL_Levels_max6>=5)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+8,SL_Level5_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,8,DoubleToStr(100*SL_Level5_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level5_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,8,DoubleToStr(100*SL_Level5_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level5_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   if(Fib_SL_Levels_max6>=6)
   {
      ObjectSet(name,OBJPROP_FIRSTLEVEL+9,SL_Level6_Fib_Pct);
      if(name=="ShortFibo")
         ObjectSetFiboDescription(name,9,DoubleToStr(100*SL_Level6_Fib_Pct,1)+"  "+DoubleToStr(p2-(SL_Level6_Fib_Pct*MathAbs(p1-p2)),Digits));
      if(name=="LongFibo")
         ObjectSetFiboDescription(name,9,DoubleToStr(100*SL_Level6_Fib_Pct,1)+"  "+DoubleToStr(p2+(SL_Level6_Fib_Pct*MathAbs(p1-p2)),Digits));
   }
   
   ObjectSet(name,OBJPROP_FIRSTLEVEL+Fib_SL_Levels_max6+4,TP_Fib_Pct);
   if(name=="ShortFibo")
      ObjectSetFiboDescription(name,Fib_SL_Levels_max6+4,DoubleToStr(100*TP_Fib_Pct,1)+"  "+DoubleToStr(p2-(TP_Fib_Pct*MathAbs(p1-p2)),Digits));
   if(name=="LongFibo")
      ObjectSetFiboDescription(name,Fib_SL_Levels_max6+4,DoubleToStr(100*TP_Fib_Pct,1)+"  "+DoubleToStr(p2+(TP_Fib_Pct*MathAbs(p1-p2)),Digits));
 
   ObjectMove(name,0,t1,p1);
   ObjectMove(name,1,t2,p2);
   
   if(name=="LongFibo")prevBuyBar1=Bars;
   if(name=="ShortFibo")prevSellBar1=Bars;
}   

/////////////////add the lines/text next to fib lines to label them///////////////
void MakeLine(double value, color c, string name, string dir)
{
   ObjectCreate(name+dir,OBJ_TREND,0,0,0,0,0);
   ObjectSet(name+dir,OBJPROP_RAY,false);
   ObjectSet(name+dir,OBJPROP_COLOR,c);
   ObjectSet(name+dir,OBJPROP_STYLE,STYLE_DOT);
   ObjectMove(name+dir,0,Time[5],value);
   ObjectMove(name+dir,1,Time[3],value);
   ObjectCreate(name+dir+"txt",OBJ_TEXT,0,0,0);
   ObjectSetText(name+dir+"txt",name,6,"",c);
   ObjectMove(name+dir+"txt",0,Time[6],value);
}

///////////////////utility to obtain open time for specified trade type////////////
///////////////////for reconstrucion of fibs/tp/sl values//////////////////////////
int SetPendingOpenTime(int type,int opentime)
{  
   int handle=FileOpen(Symbol()+type+"opentime.dat",FILE_BIN|FILE_WRITE);
   if(handle<1) return(0);
   {
      FileWriteInteger(handle,opentime);
      FileClose(handle);
      return(1);
   }
}
datetime GetPendingOpenTime(int type)
{  
   int handle;
   int value;
   handle=FileOpen(Symbol()+type+"opentime.dat", FILE_BIN|FILE_READ);
   if(handle>0)
   {
      value=FileReadInteger(handle);
      FileClose(handle);
      return(value);
   }
   else
   return(0);
}


///////////////////////function to get orderticket of most single open buy/sell per chart/////////////
int GetOrderTicket(int type)
{
   for(k=OrdersTotal()-1;k>=0;k--)
   {
      OrderSelect(k,SELECT_BY_POS,MODE_TRADES);
      
      if
      (
         OrderMagicNumber()==MagicNumber
         &&
         OrderSymbol()==Symbol()
         &&
         OrderType()==type
      )
      {
         return(OrderTicket());
         break;
      }
   }
   return(false);
}

//////////////check to be sure bid price has not passed fib entry level to avoid order entry error//////////

bool IsGoodPriceLevel(int type)
{
   if(type==OP_BUY && buys==0 && MarketInfo(Symbol(),MODE_ASK)<longEntry-stoplevel)return(true);
   if(type==OP_SELL && sells==0 && MarketInfo(Symbol(),MODE_BID)>shortEntry+stoplevel)return(true);
      
   return(false);
}


////////////////determind minimum fibo size ////////////////
////////////////and filter out trades that candles are too small/close together/////
////////////////to form fib spread out enough to get value sp/sl values/////////////
bool IsSufficientFiboSize(int type)
{

   CalcFib_t1p1_t2p2(type,1);
   
   if(type==OP_BUY && longDelta>=Min_Fibo_Size_pips){cmtfibosize="";return(true);}
   else
   if(type==OP_SELL && shortDelta>=Min_Fibo_Size_pips){cmtfibosize="";return(true);}
   else
   {
      if(type==OP_BUY)
      {
         cmtfibosize="\n                                                Long Fibo size "+DoubleToStr(longDelta/adj,0)+" is less than MinFiboSize "+DoubleToStr(Min_Fibo_Size_pips/adj,0);
      }
      else 
      if(type==OP_SELL)
      {
         cmtfibosize="\n                                                Short Fibo size "+DoubleToStr(shortDelta/adj,0)+" is less than MinFiboSize "+DoubleToStr(Min_Fibo_Size_pips/adj,0);
      }
      return(false);
   }
}


///////////function to check if condiiton exists to take another trade//////////
bool NoOpenTrades(int type)
{
   CheckOpenOrders();
   if
   (
      type==OP_BUY && buys==0 && buystops==0
      &&
      ( (NonHedging && sells==0 && sellstops==0 ) || !NonHedging)
   )
   return(true);
   
   
   if
   (
      type==OP_SELL && sells==0 && sellstops==0
      &&
      ( (NonHedging && buys==0 && buystops==0) || !NonHedging)
   )
   return(true);
   
   
   return(false);
}

///////////function to check proper candle pattern for trading system/////////////
bool IsGoodCandlePattern(int type)
{   
   if
   (  
      type==OP_BUY
      &&
      Close[1]>Open[1]
      && 
      High[1]>Close[2]+spread 
      && 
      High[1]-Close[2]>=Min_Wick_Size_prev_candle
   )
   return(true);
   
   if
   (
      type==OP_SELL
      &&
      Close[1]<Open[1]
      &&
      Low[1]<Close[2]-spread 
      && 
      Close[2]-Low[1]>=Min_Wick_Size_prev_candle
   )
   return(true);
   
   return(false);
}



//////////////////functions to open the pending trades/////////////////
void OpenLongTrade()
{
   //Print(Symbol()+" Are we here yet #1? plue NoOpenBuyTrades "+NoOpenTrades(OP_BUY));
   if(!IsTradeAllowed())
   {
      while(!IsTradeAllowed())
      {
         Comment("TradeContextBusy");
         //if(IsTradeAllowed())break;
         Sleep(100);
      }
   }
   else
   {
      //Print(Symbol()+" Ready to open trade long Are we here yet #2?");
      buyticket=0;
      buyticket=OrderSend(Symbol(),OP_BUYSTOP,lotCalculator(),longEntry+spread,3,0,0,TradeComment,MagicNumber,0,Blue);
      if(buyticket>0)
      {
         OrderSelect(buyticket,SELECT_BY_TICKET,MODE_TRADES);
         longsent = SetPendingOpenTime(OrderType(),OrderOpenTime());
         BuyTradeBar=Bars;
         BuyOpenTime=TimeCurrent();
         TradeBar=Bars;
         for(j=0;j<100;j++)
         {
            if(OrderModify(OrderTicket(),OrderOpenPrice(),longSL,longTP,0,Blue))
            {cmtlong="";break;}
            else
            {
               cmtlong="\n                                                Unable to modify SL/TP "+longSL+"/"+longTP+" "+GetLastError();
               Print(cmtlong);
            }
         }
      }
      else
      {  
         cmtlong="\n                                                Unable to open BUY - error: "+GetLastError();
         Print(cmtlong);
      }
   }
   return;
}

void OpenShortTrade()
{
   
   //Print(Symbol()+" Are we here yet #1? plus NoShortBuyTrades "+NoOpenTrades(OP_SELL));
   if(!IsTradeAllowed())
   {
      while(!IsTradeAllowed())
      {
         Comment("TradeContextBusy");
         //if(IsTradeAllowed())break;
         Sleep(100);
      }
   }
   else
   {
      sellticket=0;
      sellticket=OrderSend(Symbol(),OP_SELLSTOP,lotCalculator(),shortEntry,3,0,0,TradeComment,MagicNumber,0,Red);
      if(sellticket>0)
      {
         //Print(Symbol()+" Ready to open trade short Are we here yet #2?");
         OrderSelect(sellticket,SELECT_BY_TICKET,MODE_TRADES);
         shortsent = SetPendingOpenTime(OrderType(),OrderOpenTime());
         SellTradeBar=Bars;
         SellOpenTime=TimeCurrent();
         TradeBar=Bars;
         for(j=0;j<100;j++)
         {
            if(OrderModify(OrderTicket(),OrderOpenPrice(),shortSL,shortTP,0,Red))
            {cmtshort="";break;}
            else
            {
               cmtshort="\n                                                Unable to modify SL/TP "+shortSL+"/"+shortTP+" "+GetLastError();
               Print(cmtshort);
            }
         }
      }
      else 
      {
         cmtshort="\n                                                Unable to open SELL - error: "+GetLastError();
         Print(cmtshort);
      }
   }
   return;
}

bool isOutside_MA_Channel(int dir)
{
   /*
   extern   bool        Use_MA_Channel_Filter            = false;
   extern   int         MA_Channel_Period                = 5;
   extern   int         MA_Channel_Mode                  = MODE_SMA;
   */
   
   if(!Use_MA_Channel_Filter){cmtmachannel="";return(true);}
   if(Use_MA_Channel_Filter)
   {
      MA_High=iMA(Symbol(),0,MA_Channel_Period,0,MA_Channel_Mode,PRICE_HIGH,0);
      MA_Low=iMA(Symbol(),0,MA_Channel_Period,0,MA_Channel_Mode,PRICE_LOW,0);
            
      if
      (  
         dir==OP_BUY
         &&
         longEntry>MA_Low && longEntry<MA_High
      )
      {
         if(buystops>0)CloseAllOrders(OP_BUYSTOP);
         if(Show_Comments)cmtmachannel="\n                                                Fialed Long MA Channel Filter. No trade.";
         return(false);
      }
      else
      if
      (  
         dir==OP_SELL
         &&
         shortEntry>MA_Low && shortEntry<MA_High
      )
      {
         if(sellstops>0)CloseAllOrders(OP_SELLSTOP);
         if(Show_Comments)cmtmachannel="\n                                                Fialed Short MA Channel Filter. No trade.";
         return(false);
      }
      else
      {
         cmtmachannel="";
      }
   }
   return(true);

}


void CloseAllOrders(int type)
   {  
      if(type==OP_BUY)Print("Closing OP_BUY");
      if(type==OP_BUYSTOP)Print("Closing OP_BUYSTOP");
      if(type==OP_BUYLIMIT)Print("Closing OP_BUYLIMIT");
      if(type==OP_SELL)Print("Closing OP_SELL");
      if(type==OP_SELLSTOP)Print("Closing OP_SELLSTOP");
      if(type==OP_SELLLIMIT)Print("Closing OP_SELLLIMIT");
      double price;
      for(int t=0;t<OrdersTotal();t++)
      {
         OrderSelect(t,SELECT_BY_POS,MODE_TRADES);
         
         if
         (
            OrderMagicNumber()==MagicNumber
            && OrderSymbol()==Symbol()
         )
         {
            if(OrderType()<2)
            {
               if(OrderType()==OP_BUY)price=MarketInfo(Symbol(),MODE_BID);
               if(OrderType()==OP_SELL)price=MarketInfo(Symbol(),MODE_ASK);
               
               if(OrderType()==type || type == 6)
               {
                  if(!OrderClose(OrderTicket(),OrderLots(),price,3,Magenta))
                  {
                     Print("Order not closed "+OrderTicket()+"  "+GetLastError());
                  } 
               }    
            }
                
            if(OrderType()>1)
            {
               if(OrderType()==type)
               {
                  if(!OrderDelete(OrderTicket()))
                  {
                     Print("Order not deleted "+OrderTicket()+" "+GetLastError());
                  }
               }
            }
         }
      }
      return;
   } 
 
 
 
double lotCalculator()
{
   cmtlots="";
   if(UseAllOpenTrades4Risk)
      AmountAtRisk=AccountBalance()*RiskPercent/Total_EA_Trades*0.01;
   else
      AmountAtRisk=AccountBalance()*RiskPercent*0.01;
      
   if(IsTesting())
   {
   
      double LotValue = MarketInfo(Symbol(), MODE_LOTSIZE) * point;
      
      if(Use_StopLoss_4_risk_calc && StopLossPips!=0 && LotValue!=0)
      {
         Lots=AmountAtRisk/StopLossPips/LotValue;
      }
      else if(LotValue!=0)
      {
         Lots=AmountAtRisk/100/LotValue;
      }
      else
      Lots=MarketInfo(Symbol(),MODE_MINLOT);
   }
   else
   {   
      PointCostValue=PointCost();
      if(Use_StopLoss_4_risk_calc)
      {
         Lots=AmountAtRisk/StopLossPips/PointCostValue;
      }
      else
      {
         Lots=AmountAtRisk/100/PointCostValue;
      }
   }
   
   if(lots!=0)Lots=lots;

   if(Lots < MarketInfo(Symbol(), MODE_MINLOT))
   {
      if(Show_Comments)cmtlots="\n                                                Calculated lots "+Lots+"< MODE_MINLOT so lotsize is "+DoubleToStr(MarketInfo(Symbol(), MODE_MINLOT),2);
      Lots = MarketInfo(Symbol(), MODE_MINLOT);
   }
   else
   if
   (
      ( MaxLots!=0 && Lots > MathMin(MaxLots,MarketInfo(Symbol(), MODE_MAXLOT)) )
      ||
      ( MaxLots==0 && Lots > MarketInfo(Symbol(), MODE_MAXLOT) )
   )
   {
      if(Show_Comments)cmtlots="\n                                                Calculated lots "+DoubleToStr(Lots,2)+" is > Maximum allowed lots of  "+DoubleToStr( MathMin(MaxLots,MarketInfo(Symbol(), MODE_MAXLOT)) ,2);
      if( MaxLots!=0 && Lots > MathMin(MaxLots,MarketInfo(Symbol(), MODE_MAXLOT)) )Lots = MathMin(MaxLots,MarketInfo(Symbol(), MODE_MAXLOT));
      if( MaxLots==0 && Lots > MarketInfo(Symbol(), MODE_MAXLOT) )Lots = MarketInfo(Symbol(), MODE_MAXLOT);
      if(Show_Comments)cmtlots=cmtlots+" so lotsize will be "+DoubleToStr(Lots,2);
   }
   
   
   Lot=DoubleToStr(Lots,2);
   
   return( NormalizeDouble(Lots,2) );   
}


///////////////determine point value based on base currency to be used in lotsize/risk calculation
double PointCost() 
{
   double LotValue;
   double LotCost;
   string symbol3 = "AUDUSD";
   string symbol4 = "EURUSD";

   if(StringLen(Symbol())>6)
      SymbolExtra=StringSubstr(Symbol(), 6, StringLen(Symbol()));

   Currency=AccountCurrency();
   LotValue = MarketInfo(Symbol(), MODE_LOTSIZE) * point;

   string QuoteCurrency = StringSubstr(Symbol(), 3, 3);
   string Symbol1 = Currency + QuoteCurrency+SymbolExtra;
   string Symbol2 = QuoteCurrency + Currency+SymbolExtra;
   
   if (QuoteCurrency == Currency)
   {
      LotCost = LotValue;
   }
   else 
   {
      if (MarketInfo(Symbol1, MODE_BID) != 0.0) LotCost = LotValue * (1/MarketInfo(Symbol1, MODE_BID));
      else LotCost = LotValue * MarketInfo(Symbol2, MODE_ASK);
   }
   
   return (LotCost);
}



/////////////////windows functions to extrace UTC time for trading times//////////////
/*
datetime GetWinLocalDateTime()
{
   double hundrednSecPerSec = 10.0 * 1000000.0;
   double bit32to64 = 65536.0 * 65536.0;
   double secondsBetween1601And1970 = 11644473600.0;
   int    TimeArray[4];
   int    FileTimeArray[2];   // 100nSec since 1601/01/01 UTC
   int    LocalFileTimeArray[2];   // 100nSec since 1601/01/01 Local

   GetSystemTime(TimeArray);
   SystemTimeToFileTime(TimeArray, FileTimeArray);
   FileTimeToLocalFileTime(FileTimeArray, LocalFileTimeArray);
   
   double lfLo32 = LocalFileTimeArray[0];
   if(lfLo32 < 0)
      lfLo32 = bit32to64 + lfLo32;
   double ticksSince1601 = LocalFileTimeArray[1] * bit32to64 + lfLo32;
   double secondsSince1601 = ticksSince1601 / hundrednSecPerSec;
   double secondsSince1970 = secondsSince1601 - secondsBetween1601And1970;
   return (secondsSince1970);
}

datetime GetWinUtcDateTime()
{
   double hundrednSecPerSec = 10.0 * 1000000.0;
   double bit32to64 = 65536.0 * 65536.0;
   double secondsBetween1601And1970 = 11644473600.0;
   int    TimeArray[4];
   int    FileTimeArray[2];   // 100nSec since 1601/01/01 UTC
   GetSystemTime(TimeArray);
   SystemTimeToFileTime(TimeArray, FileTimeArray);
   
   double lfLo32 = FileTimeArray[0];
   if(lfLo32 < 0)
      lfLo32 = bit32to64 + lfLo32;
   double ticksSince1601 = FileTimeArray[1] * bit32to64 + lfLo32;
   double secondsSince1601 = ticksSince1601 / hundrednSecPerSec;
   double secondsSince1970 = secondsSince1601 - secondsBetween1601And1970;
   return (secondsSince1970);
}
*/
void CommentManagement()
{

   ///////////////////////////////comment management////////////////////////// 
   if(debug)
   {
      debug1=
      "                                                Long "
      +"\n                                                "+
      (isOutside_MA_Channel(OP_BUY)) + " MA_Channel"
      +"\n                                                "+  
         (IsGoodCandlePattern(OP_BUY)) + " CandlePattern"
         +"\n                                                "+ 
            (IsSufficientFiboSize(OP_BUY)) + " FiboSize"
            +"\n                                                "+
               (IsGoodPriceLevel(OP_BUY)) + " PriceLevel"
               +"\n                                                "+
                  (Bars-BuyTradeBar>=CandlesBetweenTrades) + " bars between trades"
                  +"\n                                                "+
                     (NoOpenTrades(OP_BUY)) + " NoOpenTrades"
                     +"\n                                                "+
                        ((Max_1_trade_per_day && NoPreviousTradesToday())||!Max_1_trade_per_day ) + " NoPreviousTradesToday"
                        +"\n                                                "+
                           (Allow_EA_Trades && Total_EA_Trades<MaxTrades) + " Allow EA and < MaxOrders";


      debug2=
      "\n                                                Short "
      +"\n                                                "+
         (isOutside_MA_Channel(OP_SELL)) + " MA_Channel"
         +"\n                                                "+  
            (IsGoodCandlePattern(OP_SELL)) + " CandlePattern"
            +"\n                                                "+ 
               (IsSufficientFiboSize(OP_SELL)) + " FiboSize"
               +"\n                                                "+
                  (IsGoodPriceLevel(OP_SELL)) + " PriceLevel"+"  "+(sells==0)+"  "+MarketInfo(Symbol(),MODE_BID)+"  "+(shortEntry+stoplevel)
                  +"\n                                                "+
                     (Bars-SellTradeBar>=CandlesBetweenTrades) + " bars between trades"
                     +"\n                                                "+
                        (NoOpenTrades(OP_SELL)) + " NoOpenTrades"
                        +"\n                                                "+
                           ((Max_1_trade_per_day && NoPreviousTradesToday())||!Max_1_trade_per_day) + " NoPreviousTradesToday"
                           +"\n                                                "+
                              (Allow_EA_Trades && Total_EA_Trades<MaxTrades) + " Allow EA and < MaxOrders";
         
   }
    
    
     
   if(Show_Comments)
   {
      FiltersComment=
      (
         cmtspread
         +
         cmttrademonday
         +
         cmttradefriday
         +
         cmttradesperday
      );  
   
      StatusComment=
      (
         cmtfibosize
         +
         cmtmachannel
         +
         cmtlongcandles
         +
         cmtshortcandles
         +
         cmtlong
         +
         cmtshort
         +
         cmtstoplosspips
         +
         cmtlots
         );
   }  
    
   if(debug)
   {
      DebugComments=
      (
         "                                                check long "+(Close[1]>Open[1])+" long bool "+long
         +"\n                                                check short "+(Close[1]<Open[1])+" short bool "+short
         +"\n"+debug1
         +"\n"+debug2
         +"\n"+debug3             
         +"\n"+debug4
      );
   }      
 
   string cmt;
      
   if(debug)cmt=cmt+DebugComments;
   if(Show_Comments)cmt=cmt+StatusComment+"\n"+FiltersComment;
   cmt=cmt+"\n                                                long "+long+" short "+short+" TradingOk "+TradingOk;
      
   Comment(cmt);   
   
      
   ///////////////////////////////////////////////////////////////////////////
      
}

void TradingLimiters()
{
   TradingOk=true;
   
   //////////check for friday close profits or close all
   if(TimeDayOfWeek(Time[0])==5 && (CloseAllTradesOnFriday || CloseWinnersOnFriday))
   {
      /*
      TimeToStr(GetWinUtcDateTime(),TIME_DATE)+" "+UTC_Time_For_Friday_Close;
      
      if(IsTesting())
      if
      (
         (
            (!IsTesting() && GetWinUtcDateTime()>=StrToTime(TradingStopTime))
            ||
            (IsTesting() && TimeHour(TimeCurrent())>=23)
         )
      )
      */
      //if(TimeLocal()>TradingStopTime)
      if(TimeHour(TimeLocal())>=Local_Hour_To_Close_Friday)
      {
         ObjectSet("friday",OBJPROP_COLOR,Red);
         
         for(i=0;i<OrdersTotal();i++)
         for(int q=0;q<OrdersTotal();q++)
         {
            OrderSelect(q,SELECT_BY_POS,MODE_TRADES);
      
            if
            (
               OrderMagicNumber()==MagicNumber
               && OrderSymbol()==Symbol()
            )
            {
               if(CloseAllTradesOnFriday)
               {    
                  if(OrderType()==OP_BUY)OrderClose(OrderTicket(),OrderLots(),MarketInfo(Symbol(),MODE_BID),3,Blue);
                  if(OrderType()==OP_SELL)OrderClose(OrderTicket(),OrderLots(),MarketInfo(Symbol(),MODE_ASK),3,Red);                   
                  if(OrderType()>1)OrderDelete(OrderTicket());
               }
            
               if( (CloseWinnersOnFriday && OrderProfit()>0) || CloseAllTradesOnFriday)
               {
                  if(OrderType()==OP_BUY)OrderClose(OrderTicket(),OrderLots(),MarketInfo(Symbol(),MODE_BID),3,Blue);
                  if(OrderType()==OP_SELL)OrderClose(OrderTicket(),OrderLots(),MarketInfo(Symbol(),MODE_ASK),3,Red);          
               }
            }
         }
      }
      TradingOk=false;
   }
   
   /////////////////check for max spread - no trades////////////////// 
   if(MarketInfo(Symbol(),MODE_SPREAD)>MaxSpread)
   {
      if(Show_Comments)cmtspread=("                                                Spread "+DoubleToStr(MarketInfo(Symbol(),MODE_SPREAD)/DigitsMulti,1)+" is greater than MaxSpread "+DoubleToStr(MaxSpread/DigitsMulti,1)+".  No trading.");
      else
      cmtspread="";
      TradingOk=false;
      //return(true);
   }
   
   ////////////////////protect against monday gap open trades/////////////////
   if( TimeDayOfWeek(Time[0])==1 && MondayGapProtection )
   {
      if(MathAbs(Close[1]-Open[0])>MondayGap)
      TradingOk=false;
      //return(true);
   }
   
   if(!Trade_Monday)
   {
      if(TimeDayOfWeek(Time[0])==1)
      {
         if(Show_Comments)cmttrademonday=("                                                No trading on Monday = true.");
         else
         cmttrademonday="";
         if(buystops>0)CloseAllOrders(OP_BUYSTOP);
         if(ObjectFind("LongFibo")>=0 && buys==0)ObjectDelete("LongFibo");
         if(ObjectFind("LongFibotxt")>=0 && buys==0)ObjectDelete("LongFibotxt");
            
         if(sellstops>0)CloseAllOrders(OP_SELLSTOP);
         if(ObjectFind("ShortFibo")>=0 && sells==0)ObjectDelete("ShortFibo");
         if(ObjectFind("ShortFibotxt")>=0 && sells==0)ObjectDelete("ShortFibotxt");
           
         TradingOk=false;
         //return(true);
      }
   }  
    
   /////////////////////if no trading friday/////////////////// 
   if(!Trade_Friday)
   {
      if(TimeDayOfWeek(Time[0])==5)
      {
         if(Show_Comments)cmttradefriday=("                                                No trading on Friday = true.");
         else
         cmttradefriday="";
         if(buystops>0)CloseAllOrders(OP_BUYSTOP);
         if(ObjectFind("LongFibo")>=0 && buys==0)ObjectDelete("LongFibo");
         if(ObjectFind("LongFibotxt")>=0 && buys==0)ObjectDelete("LongFibotxt");
            
         if(sellstops>0)CloseAllOrders(OP_SELLSTOP);
         if(ObjectFind("ShortFibo")>=0 && sells==0)ObjectDelete("ShortFibo");
         if(ObjectFind("ShortFibotxt")>=0 && sells==0)ObjectDelete("ShortFibotxt");
         
         
         TradingOk=false;
         //return(true);
      }
   }    
   return;
}

bool TradingConditions(int dir)
{
   
   if(dir==OP_BUY)
   {
      bool long=true;
      if(!isOutside_MA_Channel(OP_BUY))long=false;
      if(!IsGoodCandlePattern(OP_BUY))long=false;
      if(!IsSufficientFiboSize(OP_BUY))long=false;
      if(!IsGoodPriceLevel(OP_BUY))long=false;
      if(!(Bars-BuyTradeBar>=CandlesBetweenTrades))long=false;
      if(!NoOpenTrades(OP_BUY))long=false;
      if(!NoPreviousTradesToday() && Max_1_trade_per_day)long=false;
      if(!Allow_EA_Trades)long=false;
      if(!Total_EA_Trades<MaxTrades)long=false;
   }
   return(long);
   
   if(dir==OP_SELL)
   { 
      bool short=true;
      if(!isOutside_MA_Channel(OP_SELL))short=false;
      if(!IsGoodCandlePattern(OP_SELL))short=false;
      if(!IsSufficientFiboSize(OP_SELL))short=false;
      if(!IsGoodPriceLevel(OP_SELL))short=false;
      if(!(Bars-SellTradeBar>=CandlesBetweenTrades))short=false;
      if(!NoOpenTrades(OP_SELL))short=false;
      if(!NoPreviousTradesToday() && Max_1_trade_per_day)short=false;
      if(!Allow_EA_Trades)short=false;
      if(!Total_EA_Trades<MaxTrades)short=false;
   }
   return(short);
   
   return(false);
}  