
//| BetterVolume 1.4_TRO_MODIFIED_VERSION                        |
//| MODIFIED BY AVERY T. HORTON, JR. AKA THERUMPLEDONE@GMAIL.COM     |
//| I am NOT the ORIGINAL author 
//  and I am not claiming authorship of this indicator. 
//  All I did was modify it. I hope you find my modifications useful.|
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 C'95,33,33'
#property indicator_color2 C'40,40,40'
#property indicator_color3 Sienna
#property indicator_color4 C'35,82,51'
#property indicator_color5 LightGray
#property indicator_color6 LightBlue
#property indicator_color7 C'48,48,48'

#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width5 2
#property indicator_width6 2


extern bool   Show.Legend  = true ;

extern int     NumberOfBars = 500;
//extern string  Note = "0 means Display all bars";
extern int     MAPeriod = 100;
extern int     LookBack = 20;

extern bool Show.Message = true ;

extern int myCorner= 1;
extern int x.offset= 80 ; 
extern int y.offset= 10 ; 


extern string myFont       = "Arial Bold" ;
extern int    myFontSize   = 12 ;



extern color ClimaxHighColor  = Magenta;
extern color NeutralColor     = Yellow;
extern color LowColor         = Green;
extern color HighChurnColor   = Red;
extern color ClimaxLowColor   = Black;
extern color ClimaxChurnColor = Pink;
extern color London = Violet;

extern int    myBarWidth      = 2 ;

//+------------------------------------------------------------------+
int    redbarnum= -1 ,bluebarnum= -1 ,yellowbarnum= -1 ,greenbarnum= -1 ,whitebarnum= -1 ,magentabarnum= -1 ;

double red[],blue[],yellow[],green[],white[],magenta[],violet[];
//+------------------------------------------------------------------+

string symbol, tChartPeriod,  tShortName, TAG, tObjName06, tAlert, short_name ;  
int    digits, period, digits2,win  ; 
double point ;

int    barshift, index ;
double V,O,H,L,C,R1,V1,O1,H1,L1,C1,R2,V2,O2,H2,L2,C2,range, value;

double nHigh, nLow, nVolume, nRange ;
double Buf[] ;

color colorVolume;


double  cVOLUME, pVOLUME, VolumePct, AvgVolumePct;

string Arrow ;
//+------------------------------------------------------------------+

 
int init()
{
   Arrow        =  CharToStr(108) ;
   
   period       =  Period() ;    
   symbol       =  Symbol() ;
   digits       =  Digits ;   

 
//---- indicators
      SetIndexBuffer(0,red);
      SetIndexStyle(0,DRAW_HISTOGRAM, 0, myBarWidth, ClimaxHighColor);
      SetIndexLabel(0,"Climax High ");
      
      SetIndexBuffer(1,blue);
      SetIndexStyle(1,DRAW_HISTOGRAM, 0, myBarWidth, NeutralColor);
      SetIndexLabel(1,"Neutral");
      
      SetIndexBuffer(2,yellow);
      SetIndexStyle(2,DRAW_HISTOGRAM, 0,myBarWidth, LowColor);
      SetIndexLabel(2,"Low ");
      
      SetIndexBuffer(3,green);
      SetIndexStyle(3,DRAW_HISTOGRAM, 0,myBarWidth, HighChurnColor);
      SetIndexLabel(3,"HighChurn ");
      
      SetIndexBuffer(4,white);
      SetIndexStyle(4,DRAW_HISTOGRAM, 0,myBarWidth, ClimaxLowColor);
      SetIndexLabel(4,"Climax Low ");
      
      SetIndexBuffer(5,magenta);
      SetIndexStyle(5,DRAW_HISTOGRAM, 0,myBarWidth, ClimaxChurnColor);
      SetIndexLabel(5,"ClimaxChurn ");
      
        SetIndexBuffer(6,violet);
      SetIndexStyle(6,DRAW_HISTOGRAM, 0,myBarWidth, London);
      SetIndexLabel(6,"London");

      SetIndexBuffer(7,Buf);
      SetIndexStyle(7,DRAW_LINE);


      
      short_name = "Session Volume 1.0" ;
      IndicatorShortName(short_name);
      
      TAG = "betvol" ;

      tObjName06 = TAG + "06" ; 
      
      deinit() ;
//----
   return(0);
  }
//+------------------------------------------------------------------+
 

void ObDeleteObjectsByPrefix(string Prefix)
  {
   int L = StringLen(Prefix);
   int i = 0; 
   while(i < ObjectsTotal())
     {
       string ObjName = ObjectName(i);
       if(StringSubstr(ObjName, 0, L) != Prefix) 
         { 
           i++; 
           continue;
         }
       ObjectDelete(ObjName);
     }
  }  
//+------------------------------------------------------------------+
int deinit()
  {
       
   ObDeleteObjectsByPrefix(TAG); 
   
 
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   win =    WindowFind(short_name);
   
   double VolLowest,Range,Value2,Value3,HiValue2,HiValue3,LoValue3,tempv2,tempv3,tempv ;
   int limit;
   int counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   if ( NumberOfBars == 0 ) 
      NumberOfBars = Bars-counted_bars;
   limit=NumberOfBars; //Bars-counted_bars;
   NumberOfBars=2000;
   redbarnum= -1 ;bluebarnum= -1 ;yellowbarnum= -1 ;greenbarnum= -1 ;whitebarnum= -1 ;magentabarnum= -1 ;
      
   for(int i=0; i<limit; i++)   
   {      
         V = iVolume(symbol,period,i);
         H = iHigh(symbol,period,i);
         L = iLow(symbol,period,i);
         C = iClose(symbol,period,i);
         
         red[i]   = 0; 
         blue[i]  = V; 
                                
         yellow[i] = 0; green[i] = 0; white[i] = 0; magenta[i] = 0;
          
         
         Value2=0;Value3=0;HiValue2=0;HiValue3=0;LoValue3=99999999;tempv2=0;tempv3=0;tempv=0;
         
         index     = iLowest(symbol,period,MODE_VOLUME,LookBack,i) ;
         VolLowest = iVolume(symbol,period,index);
         
         if (TimeHour(Time[i])>=0 && TimeHour(Time[i])<8 )
         {
               if(yellowbarnum == -1) { yellowbarnum = i ; }
               yellow[i]   = NormalizeDouble(V,0);
               blue[i]     = 0 ;
         }
               
         Range  = H-L;
         Value2 = V*Range;
         
         if ( Range != 0 ) { Value3 = V/Range; }          
         
         for ( int n=i;n<i+MAPeriod;n++ ) {tempv= iVolume(symbol,period,n) + tempv; } 
            
         //v4[i] = NormalizeDouble(tempv/MAPeriod,0);
         

          for ( n=i;n<i+LookBack;n++)
          {
               nHigh   = iHigh(symbol,period,n);
               nLow    = iLow(symbol,period,n);
               nRange  = nHigh - nLow ;
               nVolume = iVolume(symbol,period,n);
               tempv2  = nVolume*nRange; 
               
               if ( tempv2 >= HiValue2 ) { HiValue2 = tempv2; }
                    
               if ( nVolume*nRange != 0 )
               {           
                     tempv3 = nVolume /nRange;
                     if ( tempv3 > HiValue3 ) 
                        HiValue3 = tempv3; 
                     if ( tempv3 < LoValue3 )
                        LoValue3 = tempv3;
               } 
          } // for n
                   
          if (TimeHour(Time[i])>=8 && TimeHour(Time[i])<14 )
          {
               if(redbarnum == -1) { redbarnum = i ; }
               red[i]    = NormalizeDouble(V,0);
               blue[i]   = 0;
               yellow[i] = 0;
               
          }   
            
          if (TimeHour(Time[i])>=14 && TimeHour(Time[i])<17 )
          {
               if(greenbarnum == -1) { greenbarnum = i ; }
               green[i]  = NormalizeDouble(V,0);                
               blue[i]   = 0;
               yellow[i] = 0;
               red[i]    =0 ;
          }
          
          if (TimeHour(Time[i])>=17 && TimeHour(Time[i])<20  )
          {
               if(magentabarnum == -1) { magentabarnum = i ; }
               magenta[i] = NormalizeDouble(V,0);
               blue[i]    = 0;
               red[i]     = 0;
               green[i]   = 0;
               yellow[i]  = 0;
          } 
          
          if (TimeHour(Time[i])>=20 && TimeHour(Time[i])<=23 )
          {
               if(whitebarnum == -1) { whitebarnum = i ; }
               white[i]   = NormalizeDouble(V,0);
               magenta[i] = 0 ;
               blue[i]    = 0 ;
               red[i]     = 0 ;
               green[i]   = 0 ;
               yellow[i]  = 0 ;
          } 
            
          if (TimeHour(Time[i])>=8 && TimeHour(Time[i])<10 )
          {
               if(whitebarnum == -1) { whitebarnum = i ; }
               violet[i]   = NormalizeDouble(V,0);
               magenta[i] = 0 ;
               blue[i]    = 0 ;
               red[i]     = 0 ;
               green[i]   = 0 ;
               yellow[i]  = 0 ;
               white[i]   =0;
          } 
          if(bluebarnum <= 0 && blue[i] >= 0) { bluebarnum = i ; } 

            
         
      } // for
      
     

//----
   
   // DoShow() ;  

  
          
    WindowRedraw() ;
//----
   return(0);
   
} // void
//+------------------------------------------------------------------+  


//+------------------------------------------------------------------+  

void setObject(string labelName,string text,int x,int y,color theColor, string font = "Courier New",int size=10,int angle=0)
{
 
      
      if (ObjectFind(labelName) == -1)
          {
             ObjectCreate(labelName,OBJ_LABEL,win,0,0);
             ObjectSet(labelName,OBJPROP_CORNER,1);
             if (angle != 0)
                  ObjectSet(labelName,OBJPROP_ANGLE,angle);
          }               
       ObjectSet(labelName,OBJPROP_XDISTANCE,x);
       ObjectSet(labelName,OBJPROP_YDISTANCE,y);
       ObjectSetText(labelName,text,size,font,theColor);
}
  

//+------------------------------------------------------------------+


         